#!/bin/sh
###############################################################################
# Copyright 2019, NixPal OU
# URL: https://www.nixpal.com
# Email: admin@nixpal.com
###############################################################################

umask 0177

echo "Installing zCloudNode"

echo "Check we're running as root"
if [ ! `id -u` = 0 ]; then
        echo
        echo "FAILED: You have to be logged in as root (UID:0) to install zCloud"
        exit
fi
echo

echo " Install Bind and Bind utils if aren't already installed"

    if [ -f /etc/redhat-release ]; then
echo "Install for RedHat Systems"
sleep 1
yum install bind bind-utils -y
mkdir /var/named/logs
chown named:named /var/named/logs
touch /var/named/logs/security.log
chown named:named /var/named/logs/security.log
semanage fcontext -a -t named_log_t '/var/named/logs(/.*)?'
restorecon -Rv /var/named/logs
systemctl enable named

    elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ]; then
apt-get install bind9 -y
systemctl enable bind9
systemctl enable bind

else
echo "unknown OS"
fi




echo "Install zCloudNode files"
cp -avf zcloudnode.conf /etc/zcloudnode.conf
cp -avf zcloudnode /usr/local/bin/zcloudnode
chmod 750 /usr/local/bin/zcloudnode
    if [ -f /etc/redhat-release ]; then
touch /var/named/zones.conf
chown root:named /var/named/zones.conf
chmod 640 /var/named/zones.conf
echo 'include "/var/named/zones.conf";' >> /etc/named.conf

    elif [ -f /etc/debian_version ] || [ -f /etc/lsb-release ]; then
touch /etc/bind/zones.conf
chown bind:bind /etc/bind/zones.conf
chmod 640 /etc/bind/zones.conf
echo 'include "/etc/bind/zones.conf";' >> /etc/bind/named.conf.local
else
echo "unknown OS"
fi


cp -avf zcloudnode.service /etc/systemd/system
chcon -h system_u:object_r:systemd_unit_file_t:s0 /etc/systemd/system/zcloudnode.service
systemctl daemon-reload
systemctl enable zcloudnode.service

