#!/bin/sh
###############################################################################
# Copyright 2022, NixPal OU
# URL: https://www.nixpal.com
# Email: admin@nixpal.com
###############################################################################

umask 0177
echo "-----------------------------------------------------------------"

echo "Installing zcloudnode"
echo "-----------------------------------------------------------------"

echo "Check we're running as root"
if [ ! `id -u` = 0 ]; then
        echo
        echo "FAILED: You have to be logged in as root (UID:0) to install zCloud"
        exit
fi
echo

echo "-----------------------------------------------------------------"


echo "Install zcloudnode conf"
sleep 1
ZCONF=/usr/local/etc/zcloudnode.conf
if [ -f "$ZCONF" ]; then
    echo "$ZCONF exist writing to /usr/local/etc/zcloudnode.conf.new"
    cp -avf zcloudnode.conf /usr/local/etc/zcloudnode.conf.new

else
    echo "$ZCONF does not exist. Copying it"
    cp -avf zcloudnode.conf /usr/local/etc/zcloudnode.conf


fi

sleep 1

echo "-----------------------------------------------------------------"

echo "Check or Install service"
cp -avf zcloudnode.FreeBSD.service  /usr/local/etc/rc.d/zcloudnode
chmod 755 /usr/local/etc/rc.d/zcloudnode
echo "-----------------------------------------------------------------"


echo "Installing binary at /usr/local/bin/ directory"
cp -avf zcloudnode /usr/local/bin/zcloudnode
chmod 750 /usr/local/bin/zcloudnode

echo "-----------------------------------------------------------------"
echo 'Dont forget to edit rc.conf and set zcloudnode_enable="YES" first '
echo "-----------------------------------------------------------------"

