#!/bin/sh
###############################################################################
# Copyright 2019, NixPal OU
# URL: https://www.nixpal.com
# Email: admin@nixpal.com
###############################################################################

umask 0177

echo "Installing zCloudAgent"

echo "Check we're running as root"
if [ ! `id -u` = 0 ]; then
        echo
        echo "FAILED: You have to be logged in as root (UID:0) to install zCloud"
        exit
fi
echo



echo "Install zCloudAgent conf"
sleep 1
ZCONF=/etc/zcloudagent.conf
if [ -f "$ZCONF" ]; then
    echo "$ZCONF exist writing to /etc/zcloudagent.conf.new"
    cp -avf zcloudagent.conf /etc/zcloudagent.conf.new
else
    echo "$ZCONF does not exist. Copying it"
    cp -avf zcloudagent.conf /etc/zcloudagent.conf

fi

sleep 1

echo "Check or Install Systemd service"
cp -avf zcloudagent.service /etc/systemd/system
chcon -h system_u:object_r:systemd_unit_file_t:s0 /etc/systemd/system/zcloudagent.service
systemctl daemon-reload

echo "Installing binary at /usr/local/bin/ directory"
cp -avf zcloudagent /usr/local/bin/zcloudagent
chmod 750 /usr/local/bin/zcloudagent


STATUS=`systemctl is-active zcloudagent.service`
  if [[ ${STATUS} == 'active' ]]; then
    echo "Running. Restarting"
    systemctl restart zcloudagent.service 
  else 
    echo " Service not running.... Enabling it only "  
    systemctl enable zcloudagent.service
  fi
