#!/bin/sh
###############################################################################
# Copyright 2022, NixPal OU
# URL: https://www.nixpal.com
# Email: admin@nixpal.com
###############################################################################

umask 0177
echo "-----------------------------------------------------------------"

echo "Installing zCloudAgent"
echo "-----------------------------------------------------------------"

echo "Check we're running as root"
if [ ! `id -u` = 0 ]; then
        echo
        echo "FAILED: You have to be logged in as root (UID:0) to install zCloud"
        exit
fi
echo

echo "-----------------------------------------------------------------"


echo "Install zCloudAgent conf"
sleep 1
ZCONF=/usr/local/etc/zcloudagent.conf
if [ -f "$ZCONF" ]; then
    echo "$ZCONF exist writing to /usr/local/etc/zcloudagent.conf.new"
    cp -avf zcloudagent.conf /usr/local/etc/zcloudagent.conf.new

else
    echo "$ZCONF does not exist. Copying it"
    cp -avf zcloudagent.conf /usr/local/etc/zcloudagent.conf


fi

sleep 1

echo "-----------------------------------------------------------------"

echo "Check or Install service"
cp -avf zcloudagent.FreeBSD.service  /usr/local/etc/rc.d/zcloudagent
chmod 755 /usr/local/etc/rc.d/zcloudagent
echo "-----------------------------------------------------------------"


echo "Installing binary at /usr/local/bin/ directory"
cp -avf zcloudagent /usr/local/bin/zcloudagent
chmod 750 /usr/local/bin/zcloudagent

echo "-----------------------------------------------------------------"
echo 'Dont forget to edit rc.conf and set zcloudagent_enable="YES" first '
echo "-----------------------------------------------------------------"

