@extends('layouts.app')
@section('title') Zones @endsection
@section('content')
<div x-data="{ notification_success: true, open: false, ex_open: false, zone: '', server_name: '', server_id: '', re_open: false, re_zone: '', re_server_name: '', re_server_id: '', spinner_show: true, exclude_comment: '' }">
  @include('layouts.dns-check')

  <div x-data="notification()" x-init="init()">
    <div
      x-cloak
      x-show="isVisible"
      x-transition:enter="transition ease-out duration-300"
      x-transition:enter-start="opacity-0 transform translate-y-2"
      x-transition:enter-end="opacity-100 transform translate-y-0"
      x-transition:leave="transition ease-in duration-200"
      x-transition:leave-start="opacity-100 transform translate-y-0"
      x-transition:leave-end="opacity-0 transform translate-y-2"
      class="fixed inset-x-0 top-10 z-20 flex items-center justify-center px-4 py-6 pointer-events-none sm:p-6 sm:items-start sm:justify-center"
    >
      <div :class="notification_success ? 'bg-green-600' : 'bg-red-600'" class="max-w-sm w-full shadow-lg text-white rounded-lg pointer-events-auto">
        <div class="p-4">
          <p class="text-sm text-center" x-text="message"></p>
        </div>
      </div>
    </div>
  </div>
  <div x-cloak
       @keydown.window.escape="ex_open = false"
       x-show="ex_open"
       class="relative z-10"
       aria-labelledby="modal-title"
       x-ref="dialog"
       aria-modal="true">
  
    <div x-show="ex_open"
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-description="Background backdrop, show/hide based on modal state."
         class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
         aria-hidden="true"></div>
  
  
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
      <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
        <div x-show="ex_open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave="ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-description="Modal panel, show/hide based on modal state."
             class="relative transform overflow-hidden rounded-lg border-t-2 border-orange-600 bg-white dark:bg-slate-800 text-left shadow-xl transition-all my-8 w-full max-w-lg"
             @click.away="ex_open = false">
          <div class="bg-white dark:bg-slate-800 px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
            <div class="sm:flex sm:flex-col sm:items-start">
              <div class="sm:flex sm:flex-row items-center">
                <div class="mx-auto flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-full bg-gray-100 sm:mx-0 sm:h-10 sm:w-10">
                <svg xmlns="http://www.w3.org/2000/svg"
                     viewBox="0 0 20 20"
                     fill="currentColor"
                     class="size-5 fill-orange-600">
                  <path fill-rule="evenodd"
                        d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495ZM10 5a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-3.5A.75.75 0 0 1 10 5Zm0 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
                        clip-rule="evenodd" />
                </svg>
                </div>
                <div class="mt-3 w-full text-center sm:ml-4 sm:mt-0 sm:text-left text-gray-900 dark:text-white">
                  <h3 class="text-lg font-semibold leading-6"
                      id="modal-title">
                      Exclude zone <span x-text="zone"></span> from <span x-text="server_name" class="underline"></span>
                  </h3>
                  <hr class="border-slate-200 dark:border-slate-700 my-3">
                  <div class="text-base">
                    This action will exclude the zone <span class="font-bold" x-text="zone"></span> from <span class="font-bold" x-text="server_name"></span>.
                  </div>
                  <div>
                    <input x-model="exclude_comment" x-text="exclude_comment" placeholder="Optional comment" type="text" class="mt-3 bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white w-full">
                  </div>
                </div>
              </div>  
            </div>
          </div>
          <div class="px-4 py-3 text-center">
            <button type="button"
                    class="mt-3 inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-orange-700 rounded-lg hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-orange-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white"
                    @click="exclude_zone($data); ex_open = false">Exclude</button>
          </div>
        </div>
  
      </div>
    </div>
  </div>



  <!-- Remove exclude -->

  <div x-cloak
       @keydown.window.escape="re_open = false"
       x-show="re_open"
       class="relative z-10"
       aria-labelledby="modal-title"
       x-ref="dialog"
       aria-modal="true">
  
    <div x-show="re_open"
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-description="Background backdrop, show/hide based on modal state."
         class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
         aria-hidden="true"></div>
  
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
      <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
        <div x-show="re_open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave="ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-description="Modal panel, show/hide based on modal state."
             class="relative transform overflow-hidden rounded-lg border-t-2 border-orange-600 bg-white dark:bg-slate-800 text-left shadow-xl transition-all my-8 w-full max-w-lg"
             @click.away="re_open = false">
          <div class="bg-white dark:bg-slate-800 px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
            <div class="sm:flex sm:flex-col sm:items-start">
              <div class="sm:flex sm:flex-row items-center">
                <div class="mx-auto flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-full bg-gray-100 sm:mx-0 sm:h-10 sm:w-10">
                <svg xmlns="http://www.w3.org/2000/svg"
                     viewBox="0 0 20 20"
                     fill="currentColor"
                     class="size-5 fill-orange-600">
                  <path fill-rule="evenodd"
                        d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495ZM10 5a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-3.5A.75.75 0 0 1 10 5Zm0 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
                        clip-rule="evenodd" />
                </svg>
                </div>
                <div class="mt-3 w-full text-center sm:ml-4 sm:mt-0 sm:text-left text-gray-900 dark:text-white">
                  <h3 class="text-lg font-semibold leading-6"
                      id="modal-title">
                      Remove exclusion of zone <span x-text="re_zone"></span> from <span x-text="re_server_name" class="underline"></span>
                  </h3>
                  <hr class="border-slate-200 dark:border-slate-700 my-3">
                  <div class="text-base">
                    This action will remove the exclusion of the zone <span class="font-bold" x-text="re_zone"></span> from <span class="font-bold" x-text="re_server_name"></span>.
                  </div>
                </div>
              </div>  
            </div>
          </div>
          <div class="px-4 py-3 text-center">
            <button type="button"
                    class="mt-3 inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-orange-700 rounded-lg hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-orange-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white"
                    @click="remove_exclude_zone($data); re_open = false">Remove exclude</button>
          </div>
        </div>
  
      </div>
    </div>
  </div>

<div class="flex gap-3 flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="basis-3/5">
    <div class="flex-1 justify-between h-fit border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900 rounded-md shadow-md p-4 hover:shadow-lg hover:transition-all">
      <div class="p-5 text-center">
        <h3 class="text-2xl font-medium">
          All zones
        </h3>
      </div>
      <hr class="border-slate-200 dark:border-slate-700 mb-3">
        @if ($zones === 0)
          No zones found.
        @else
          @if($disable_zones_complete_load)
            <div class="mb-3 text-center inline-flex items-center  block w-full">
              <input type="text" placeholder="Search zones by name"
                      id="search_zones"
                      class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-s-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white">
              <button @click="search_zones" class="px-4 py-2 font-medium text-gray-900 bg-white border-y border-e border-gray-200 rounded-e-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700"
                      id="btn_search_zones">
                Search
              </button>
            </div>
          @else
            <div x-show="spinner_show" id="spinner" role="status" class="text-center" x-on:spinner-show.window="spinner_show=true" x-on:spinner-hide.window="spinner_show=false">
                <svg aria-hidden="true" class="inline my-3 w-8 h-8 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                </svg>
                <span class="sr-only">Loading...</span>
            </div>
          @endif
          <div class="overflow-x-auto">
            <table id="table_zones"
              class="border-collapse table-auto w-full h-full text-sm">
              <thead>
                <tr>
                <th class="">Name</th>
                <th class="">Server</th>
                <th class="">Owner</th>
                <th class="">Insert date</th>
                <th class=""></th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        @endif
      </div>
    </div>
    <div class="basis-2/5 h-fit flex flex-col gap-3">
      <div class="flex-1 justify-between border-l-2 border-orange-600 flex-col bg-white dark:bg-slate-900  rounded-md p-4 hover:transition-all">
      <h3 class="text-center text-2xl font-medium">
        Excluded
      </h3>
      <hr class="border-slate-200 dark:border-slate-700 my-3">
      <div class="overflow-x-auto">
        <table id="table_excluded_zones"
               class="border-collapse table-auto w-full h-full text-sm">
          <thead>
            <tr>
              <th class="">Name</th>
              <th class="">Server</th>
              <th class="">Reason</th>
              <th class=""></th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>

    <div class="flex-1 justify-between border-l-2 border-red-600 flex-col bg-white dark:bg-slate-900  rounded-lg p-4 hover:transition-all">
      <h3 class="text-center text-2xl font-medium">
        Duplicates
      </h3>
      <hr class="border-slate-200 dark:border-slate-700 my-3">
      <div class="overflow-x-auto">
        <table id="table_duplicate_zones"
               class="border-collapse table-auto w-full h-full text-sm">
          <thead>
            <tr>
              <th class="">Zone</th>
              <th class="">Servers</th>
              <th class="">Active</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>


<script type="text/javascript">
  const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_zones').classList.remove('text-gray-500');
    document.getElementById('menu_zones').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_zones').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_zones').classList.remove('hover:text-gray-100');
    document.getElementById('menu_zones').classList.add('text-gray-100');
    document.getElementById('menu_zones').classList.add('bg-opacity-25');
    document.getElementById('menu_zones').classList.add('bg-gray-700');
    document.getElementById('menu_zones').classList.add('border-e-2');
    document.getElementById('menu_zones').classList.add('border-indigo-400');

    duplicate_zones_table = new DataTable("#table_duplicate_zones",
      {
        perPageSelect: [20, 100, 500, ["All", 0]],
        rowRender: (row, tr, _index) => {
          if (tr.childNodes) {
            tr.attributes.class = "border-y border-slate-200 dark:border-slate-600";
            tr.childNodes.forEach(td => {
              td.attributes.class = "p-1 text-center";
            });
          }
        },
        data: {
          headings: [
            {
              text: 'Zone',
              data: 'zone'
            },
            {
              text: 'Servers',
              data: 'duplicate_servers',
            },
            {
              text: 'Active',
              data: 'active_no',
            },
          ],
        },
        columns: [
          { select: 0, data: 'zone', headerClass: 'font-medium p-3', },
          {
            headerClass: 'font-medium p-3',
            select: 1,
            type: "other",
            data: 'duplicate_servers',
            render: (data, _td, _rowIndex, _cellIndex) => {
              btns = [];
              data.duplicate_servers.forEach((dup_server) => {
                var already_excluded = "";
                if (data.excluded_in instanceof Array)
                {
                  data.excluded_in.forEach((excluded_in) => {
                  if (excluded_in.server_id == dup_server.id) {
                    already_excluded = "disabled title='excluded'";
                }
                });
              }
                btns.push(`<button x-on:click="ex_open = true; server_name = '${dup_server.name}'; server_id = ${dup_server.id}; zone = '${data.zone}'" class="py-1 px-2 text-xs text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white disabled:opacity-50" ${already_excluded}>${dup_server.name}</button>`);
              });
              return btns.join("");
            }
          },
          {
            headerClass: 'font-medium p-3',
            select: 2,
            type: "number",
            data: 'active_no',
          },
        ]
      }
    );

      excluded_zones_table = new DataTable("#table_excluded_zones",
      {
        perPageSelect: [20, 100, 500, ["All", 0]],
        rowRender: (row, tr, _index) => {
          if (tr.childNodes) {
            tr.attributes.class = "border-y border-slate-200 dark:border-slate-600";
            tr.childNodes.forEach(td => {
              td.attributes.class = "p-1 text-center";
            });
          }
        },
        data: {
          headings: [
            {
              text: 'Zone',
              data: 'zone'
            },
            {
              text: 'Server',
              data: 'server_name',
            },
            {
              text: 'Reason',
              data: 'exclude_comment',
            },
            {
              text: 'Exclude',
              data: 'exclude',
            }
          ],
        },
        columns: [
          { select: 0, data: 'zone', headerClass: 'font-medium p-3', },
          {
            headerClass: 'font-medium p-3',
            select: 1,
            data: 'server_name'
          },
          {
            headerClass: 'font-medium p-3',
            select: 2,
            data: 'exclude_comment',
            type: 'string',
            render: (data, _td, _rowIndex, _cellIndex) => {
              if ( null == data || data == '')
              {
                return '-';
              }
              else
              {
                return `<div title="${data}" x-on:click='show_comment = !show_comment' x-data="{ show_comment: false }" class="flex justify-center hover:cursor-pointer"><svg x-show='!show_comment' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
  <path fill-rule="evenodd" d="M2 10a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm8 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-3-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm7 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" clip-rule="evenodd" />
</svg><span x-show='show_comment'>${data}</span></div>
`;
              }
            }
          },
          {
            headerClass: 'font-medium p-3',
            select: 3,
            data: 'exclude',
            type: "other",
            render: (data, _td, _rowIndex, _cellIndex) => {
              return `<button x-on:click="re_open = true; re_server_name = '${data.server_name}'; re_server_id = ${data.server_id}; re_zone = '${data.zone}'" class="py-1 px-2 text-xs text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white">Remove</button>`;
            }
          }
        ]
      }
    );

    zones_table = new DataTable("#table_zones",
      {
        perPageSelect: [20, 100, 500, ["All", 0]],
        rowRender: (row, tr, _index) => {
          if (tr.childNodes) {
            tr.attributes.class = "border-y border-slate-200 dark:border-slate-600";
            tr.childNodes.forEach(td => {
              td.attributes.class = "p-1 text-center";
            });
          }
        },
        data: {
          headings: [
            {
              text: 'Zone',
              data: 'zone'
            },
            {
              text: 'Server',
              data: 'server_name',
            },
            {
              text: 'Owner',
              data: 'owner',
            },
            {
              text: 'Insert date',
              data: 'insert_date',
            },
            {
              text: 'Actions',
              data: 'actions'
            }
          ],
        },
        columns: [
          { select: 0, data: 'zone', headerClass: 'font-medium p-3', },
          {
            headerClass: 'font-medium p-3',
            select: 1,
            data: 'server_name'
          },
          {
            select: 2,
            data: 'owner',
            headerClass: 'font-medium p-3',
            render: data => {
              if ("null" === data[0].data)
                return "N/A";
            }
          },
          {
            select: 3,
            data: 'insert_date',
            type: 'date',
            format: 'YYYY-MM-DD HH:mm:ss',
            headerClass: 'font-medium p-3',
          },
          {
            select: 4,
            data: 'actions',
            type: "other",
            headerClass: 'font-medium p-3',
            render: (data) => {
              return `<div class="inline-flex rounded-md shadow-sm" role="group"><button x-on:click="open=true;zone='${data.zone}';document.getElementById('dig_results').classList.add('hidden')" class="px-2 py-1 text-xs text-gray-900 bg-white border border-gray-200 rounded-s-md hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">check DNS</button><button x-on:click="ex_open = true; server_name = '${data.server_name}'; server_id = ${data.server_id}; zone = '${data.zone}'" class="px-2 py-1 text-xs text-gray-900 bg-white border border-gray-200 rounded-e-md hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white">Exclude</button></div>`;
            }
          }
        ]
      }
    );
    @if(!$disable_zones_complete_load)
      load_all_zones();
    @endif
    load_excluded();
    load_duplicates();

    function load_all_zones()
    {
      fetch('/zones/all', {
      method: 'GET',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      }
      })
      .then(response => response.json())
      .then(data => {
        var table_data = [];
        data.zones.forEach((obj) => {
          const record = { zone: obj.zone, server_name: obj.server_name, owner: obj.owner, insert_date: obj.insert_date, actions: { id: obj.id, zone: obj.zone, server_name: obj.server_name, server_id: obj.server_id }};
          table_data.push(record);

        }, undefined, table_data);

        zones_table.insert(table_data);

        if ( data.more )
        {
          getMoreZones(data.after);
        }
        else
        {
          window.dispatchEvent(new CustomEvent('spinner-hide'));
        }
      })
      .catch(error => {
        console.error('Error:', error);
      });
    }
    

    function getMoreZones(after_id) {
      fetch('/zones/all', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': csrfToken
        },
        body: JSON.stringify({ id: after_id })
      })
        .then(response => response.json())
        .then(data => {
          var table_data = [];
          data.zones.forEach((obj) => {
            const record = { zone: obj.zone, server_name: obj.server_name, owner: obj.owner, insert_date: obj.insert_date, actions: { id: obj.id, zone: obj.zone, server_name: obj.server_name, server_id: obj.server_id }};
            table_data.push(record);

          }, undefined, table_data);

          zones_table.insert(table_data);
          if (data.more) {
            getMoreZones(data.after);
          }
          else
          {
            window.dispatchEvent(new CustomEvent('spinner-hide'));
          }
        })
        .catch(error => {
          console.error('Error:', error);
        });
    };
    
  
    
  });
  
  function exclude_zone(data)
  {
    fetch('/zones/exclude', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ zone: data.zone, server: data.server_id, exclude_comment: data.exclude_comment })
    })
    .then(response => response.json())
    .then(response => {
      if ( response.code == 'ok')
      {
        showNotification(`Zone ${data.zone} excluded.`, true);
        data.exclude_comment = '';
      }
      else
      {
        showNotification(`Problem excluding ${data.zone}.<br/>${data.message}`, false);
      }
      load_excluded();
      load_duplicates();
    })
    .catch(error => {
      console.error('Error:', error);
    });
  }

  function remove_exclude_zone(data)
  {
    fetch('/zones/exclude/remove', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ zone: data.re_zone, server: data.re_server_id })
    })
    .then(response => response.json())
    .then(response => {
      if ( response.code == 'ok')
      {
        showNotification(`Zone ${data.zone} exclusion removed.`, true);
      }
      else
      {
        showNotification(`Problem excluding ${data.zone}.<br/>${data.message}`, false);
      }
      load_excluded();
      load_duplicates();
    })
    .catch(error => {
      console.error('Error:', error);
    });
  }

  function load_excluded() {
      fetch('/zones/excluded', {
        method: 'GET',
        headers: {
          'X-CSRF-TOKEN': csrfToken,
          'Content-Type': 'application/json'
        }
      })
        .then(response => response.json())
        .then(data => {
          excluded_zones_table.data.data = [];
          var table_data = [];
          data.forEach((obj) => {
            const record = { zone: obj.zone, server_name: obj.server_name, exclude: { server_id: obj.server_id, server_name: obj.server_name, zone: obj.zone }, exclude_comment: obj.exclude_comment };
            table_data.push(record);
          }, undefined, table_data);
          excluded_zones_table.insert(table_data);
        })
        .catch(error => {
          console.error('Error:', error);
        });
    }

    function load_duplicates() {
      @if($hide_single_server_zones_in_dup_list) 
        var dup_url = "/zones/duplicates/no_singles";
      @else
        var dup_url = "/zones/duplicates";
      @endif

      fetch(dup_url, {
        method: 'GET',
        headers: {
          'X-CSRF-TOKEN': csrfToken,
          'Content-Type': 'application/json'
        }
      })
        .then(response => response.json())
        .then(data => {
          var table_data = [];
          duplicate_zones_table.data.data = [];
          data.forEach((obj) => {
            const record = { zone: obj.zone, duplicate_servers: { zone: obj.zone, duplicate_servers: obj.duplicate_servers, excluded_in: obj.excluded_in }, active_no: obj.not_excluded_server_count };
            table_data.push(record);
          }, undefined, table_data);
          duplicate_zones_table.insert(table_data);
        })
        .catch(error => {
          console.error('Error:', error);
        });
    }

    function notification() {
      return {
        isVisible: false,
        notification_status: true,
        message: '',
        init() {
          window.showNotification = this.show.bind(this);
        },
        show(msg, status) {
          this.message = msg;
          this.notification_success = status;
          this.isVisible = true;
          delay = status ? 3000 : 6000;
          setTimeout(() => {
            this.isVisible = false;
          }, delay);
        }
      }
    }
  function search_zones()
  {
    const query = document.getElementById('search_zones').value;
    if ( query == '' )
      exit;
    zones_table.data.data = [];
    fetch('/zones/search', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
      body: JSON.stringify({ query: query}),
    })
    .then(response => response.json())
    .then(data => {
      var table_data = [];
        data.forEach((obj) => {
          const record = { zone: obj.zone, server_name: obj.server_name, owner: obj.owner, insert_date: obj.insert_date, actions: { id: obj.id, zone: obj.zone, server_name: obj.server_name, server_id: obj.server_id } };
          table_data.push(record);

        }, undefined, table_data);

        zones_table.insert(table_data);
    })
    .catch(error => {
      console.error('Error:', error);
    });
  }
  @include('layouts.dns-check-js')
</script>
</div>
@endsection