@extends('layouts.app')
@section('title') Two-Factor Authentication @endsection
@section('content')

<div class="flex gap-3 flex-col my-4 animate-slide-up-fade-in items-center ">
  <div class="flex-1 justify-between lg:w-1/3 border-t border-slate-300 dark:border-slate-700 flex-col bg-white dark:bg-slate-900  rounded-lg shadow-md p-4 hover:shadow-lg hover:transition-all">
    <form method="POST" action="{{ route('two-factor.login.store') }}">
    @csrf
    <div class="p-5 grid gap-3 justify-items-center" x-data="{ view: 'totp' }">
      <div>
        <img src="/images/logo.png" alt="zone Cloud logo"
              class="dark:invert dark:bg-transparent">
      </div>
      @error('code')
      <div class="my-3">
       <span class="text-red-500">
        <strong>{{ $message }}</strong>
       </span>
      </div>
      @enderror
      @error('recovery_code')
      <div class="my-3">
       <span class="text-red-500">
        <strong>{{ $message }}</strong>
       </span>
      </div>
      @enderror
      <div class="w-full" >
       <input x-show="view=='totp'" type="text"
          class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
          placeholder="TOTP Code"
          id="code" name="code" value="" autocomplete="code" autofocus
          >
         <input x-show="view=='recovery_code'" type="text"
            class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
            placeholder="Recovery code"
            id="recovery_code" name="recovery_code" value=""  autocomplete="recovery_code"
            >
      </div>
      <div>
       <span class="text-sm cursor-pointer"  x-on:click="(view == 'totp') ? view = 'recovery_code' : view = 'totp';">Click here if you want to login using a <span class='font-bold' x-text='(view == "totp") ? "recovery" : "TOTP"'></span> code.</span>
      </div>
      <div>
        <button class="bg-gray-100 border border-gray-300 text-gray-900 p-2 text-base rounded-md dark:bg-gray-600 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 hover:bg-gray-200" type="submit">Verify</button>
      </div>
    </div>
    </form>
  </div>
</div>
<script>
</script>
@endsection
