@extends('layouts.app')
@section('title') Clusters @endsection
@section('content')
<div class="mt-4 flex-1 border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900 pb-4 rounded-lg drop-shadow-md animate-slide-up-fade-in">
  <div class="flex-1 text-center py-4">
    <a href="{{ route('add-cluster-form') }}"
       class="inline-flex items-center  px-4 py-2 font-medium bg-white border border-gray-200 rounded-lg dark:bg-gray-800 dark:border-gray-700">
      <svg xmlns="http://www.w3.org/2000/svg"
           viewBox="0 0 20 20"
           fill="currentColor"
           class="size-5 me-2">
        <path d="M10.75 4.75a.75.75 0 0 0-1.5 0v4.5h-4.5a.75.75 0 0 0 0 1.5h4.5v4.5a.75.75 0 0 0 1.5 0v-4.5h4.5a.75.75 0 0 0 0-1.5h-4.5v-4.5Z" />
      </svg>
      Add cluster
    </a>
  </div>
  <div class="p-4">
    <hr class="border-slate-200 dark:border-slate-700">
    @if (count($clusters) === 0)
      <div class="text-center my-4">
        <span class="font-semibold p-2 dark:text-orange-400 text-orange-600 border border-orange-400 rounded-md">No clusters found.</span>
      </div>
  @else
    <div class="overflow-x-auto ">
    <table class="border-collapse table-auto w-full text-sm mt-2">
    <thead>
    <tr class="text-center">
      <th class="p-2">
      Name</th>
      <th class="p-2">
      Notifications</th>
      <th class="p-2">
      Servers (Alive / Total)</th>
      <th class="p-2">
      Zones (Total / Excluded)</th>
      <th class="p-2">
      </th>
    </tr>
    </thead>
    <tbody>
    @foreach ($clusters as $cluster)
    <tr class="border-y border-slate-200 dark:border-slate-600 text-center">
      <td class="p-1">
      {{ $cluster->name }}
      </td>
      <td class="p-1">
      @if($cluster->email_notifications)
      On
    @else
      Off
    @endif
      </td>
      <td class="p-1">
      <span class="text-green-600">{{ $cluster->getAvailableServers() }}</span> /
      {{ $cluster->getTotalServers() }}
      </td>
      <td class="p-1">
      {{ $cluster->getTotalZones() }} / {{ $cluster->getExcludedZones() }}
      </td>
      <td class="p-1">
      <div class="inline-flex rounded-md shadow-sm"
       role="group">
      <a href="{{ route('edit-cluster-form', ['id' => $cluster->id]) }}"
       class="inline-flex items-center px-2 py-1 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-s-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
      <svg class="w-4 h-4 me-2"
         xmlns="http://www.w3.org/2000/svg"
         fill="none"
         viewBox="0 0 24 24"
         stroke-width="1.5"
         stroke="currentColor"
         class="size-6">
        <path stroke-linecap="round"
        stroke-linejoin="round"
        d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
      </svg>

      Edit
      </a>
      <a href="{{ route('delete-cluster-form', ['id' => $cluster->id]) }}"
       class="inline-flex items-center px-2 py-1 text-sm font-medium text-red-900 bg-white border-y border-r rounded-e-lg border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-red-400 dark:hover:bg-gray-700">
      <svg class="w-4 h-4 me-2"
         xmlns="http://www.w3.org/2000/svg"
         fill="none"
         viewBox="0 0 24 24"
         stroke-width="1.5"
         stroke="currentColor"
         class="size-6">
        <path stroke-linecap="round"
        stroke-linejoin="round"
        d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
      </svg>

      Delete
      </a>
      </div>
      </td>
    </tr>
  @endforeach
    </tbody>
    </table>
    </div>
@endif
  </div>
</div>
<script type="text/javascript">
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_clusters').classList.remove('text-gray-500');
    document.getElementById('menu_clusters').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_clusters').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_clusters').classList.remove('hover:text-gray-100');
    document.getElementById('menu_clusters').classList.add('text-gray-100');
    document.getElementById('menu_clusters').classList.add('bg-opacity-25');
    document.getElementById('menu_clusters').classList.add('bg-gray-700');
    document.getElementById('menu_clusters').classList.add('border-e-2');
    document.getElementById('menu_clusters').classList.add('border-indigo-400');
  });
</script>
@endsection