@extends('layouts.app')
@section('title') Reset password @endsection
@section('content')

<div class="flex gap-3 flex-col my-4 animate-slide-up-fade-in items-center ">
  <div class="flex-1 justify-between lg:w-1/3 border-t border-slate-300 dark:border-slate-700 flex-col bg-white dark:bg-slate-900  rounded-lg shadow-md p-4 hover:shadow-lg hover:transition-all">
    <form method="POST" action="{{ route('password.update') }}">
      @csrf
      <input type="hidden" name="token" value="{{ $token }}">
      <div class="p-5 grid gap-3 justify-items-center">
        <div>
          <img src="/images/logo.png" alt="zone Cloud logo"
                class="dark:invert dark:bg-transparent">
        </div>
        @error('email')
          <span class="text-red-500">
            <strong>{{ $message }}</strong>
          </span>
        @enderror
        @error('password')
          <span class="text-red-500">
            <strong>{{ $message }}</strong>
          </span>
        @enderror
        @error('email')
          <span class="text-red-500">
            <strong>{{ $message }}</strong>
          </span>
        @enderror
        <div class="w-full">
          <input class="bg-gray-300 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="E-mail" id="email" type="email" name="email" value="{{ $email ?? old('email') }}" required readonly>
        </div>
        <div class="w-full">
          <input class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="New password" id="password" type="password" name="password" required autocomplete="new-password">
        </div>
        <div class="w-full">
          <input class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" placeholder="Confirm new password" id="password-confirm" type="password" name="password_confirmation" required autocomplete="new-password">
        </div>
        <div>
          <button class="bg-gray-100 border border-gray-300 text-gray-900 p-2 text-base rounded-md dark:bg-gray-600 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 hover:bg-gray-200" type="submit">Reset</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
