@extends('layouts.app')
@section('title') Login @endsection
@section('content')

<div class="flex gap-3 flex-col my-4 animate-slide-up-fade-in items-center ">
  <div class="flex-1 justify-between lg:w-1/3 border-t border-slate-300 dark:border-slate-700 flex-col bg-white dark:bg-slate-900  rounded-lg shadow-md p-4 hover:shadow-lg hover:transition-all">
    <form method="POST" action="{{ route('login') }}">
    @csrf
    <div class="p-5 grid gap-3 justify-items-center">
      <div>
        <img src="/images/logo.png" alt="zone Cloud logo"
              class="dark:invert dark:bg-transparent">
      </div>
        @error('email')
          <div class="my-3">
            <span class="text-red-500">
              <strong>{{ $message }}</strong>
            </span>
          </div>
          @enderror
          @error('password')
          <div class="my-3">
            <span class="text-red-500">
              <strong>{{ $message }}</strong>
            </span>
          </div>
          @enderror
      <div class="w-full">
        <input type="email"
               class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
               placeholder="Login email"
               id="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus
               >
      </div>
      <div class="w-full">
        <input type="password"
               class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
               placeholder="Login password"
               id="password" name="password" required autocomplete="current-password"
               >
      </div>
      <div class="w-full font-semibold">
        <input  type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
        <label for="remember">
            Remember Me
        </label>
      </div>
      <div>
        <button class="bg-gray-100 border border-gray-300 text-gray-900 p-2 text-base rounded-md dark:bg-gray-600 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 hover:bg-gray-200" type="submit">Login</button>
      </div>
      <div class="text-sm">
        @if (Route::has('password.request'))
          <a class="underline" href="{{ route('password.request') }}">
            Forgot password?
          </a>
        @endif
      </div>
    </div>
    </form>
  </div>
</div>
<script>
</script>
@endsection
