/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.css",
  ],
  theme: {
    extend: {
      keyframes: {
        'slide-up-fade-in': {
          '0%': { opacity: 0, transform: 'translateY(20px)' },
          '100%': { opacity: 1, transform: 'translateY(0)' },
        },
        'slide-down-fade-in': {
          '0%': { opacity: 0, transform: 'translateY(-20px)' },
          '100%': { opacity: 1, transform: 'translateY(0)' },
        },
      },
      animation: {
        'slide-up-fade-in': 'slide-up-fade-in 0.5s ease-out forwards',
        'slide-down-fade-in': 'slide-down-fade-in 0.1s ease-out forwards',
      },
    },
  },
  plugins: [],
  darkMode: 'selector',
}
