function getZoneInfo(zone, type)
  {
    document.getElementById('dig_results').classList.remove('hidden');
    document.getElementById('dig_results').innerHTML = '<div class="relative h-3 w-3"><span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-cyan-600 opacity-75"></span></div>';
    fetch('/digcheck', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ zone: zone, type: type })
    })
    .then(response => response.json())
    .then(response => {
      console.log(response);
      var output = '<table class="animate-slide-up-fade-in">';
      for (var i = 0; i < response.message.length; i++) {
        output = output + '<tr><td class="p-2 border border-gray-200 dark:border-gray-700">' + Object.keys(response.message[i])[0] + ':</td><td class="p-2 border border-gray-200 dark:border-gray-700">';
        for (var key in response.message[i]) {
          output = output + ' ' + response.message[i][key];
        }
        output = output + '</td></tr>';
      }
      output = output + '</table>';
      if ( response.code !== "ok")
      {
        output = "Command failed.";
      }
      document.getElementById('dig_results').innerHTML = output;
    })
  }