@extends('layouts.app')
@section('title') Delete server @endsection
@section('content')
<div class="flex flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 border-t border-slate-300 dark:border-slate-700 flex-col bg-slate-100 dark:bg-slate-800  rounded-lg px-4 py-10 drop-shadow-md">
    @if ($server == null)
      <div class="rounded bg-orange-100 p-4 mb-4 text-orange-700 md:p-5 dark:bg-orange-900/75 dark:text-orange-100 animate-slide-up-fade-in">
        <div class="mb-2 flex items-center">
          <h3 class="font-semibold">Error!</h3>
        </div>
        <p class="ml-8">
          Server not found.
        </p>
      </div>
    @else
      <div class="rounded bg-orange-100 p-4 mb-4 text-orange-700 md:p-5 dark:bg-orange-900/75 dark:text-orange-100 animate-slide-up-fade-in">
        <div class="mb-2 flex items-center">
          <h3 class="font-semibold">Warning!</h3>
        </div>
        <p class="ml-8">
        Deleting {{ $server->name }} will delete its zones from zCloud's database.
        </p>
      </div>
      <form method="POST" action="">
        <hr class="border-slate-200 dark:border-slate-700"></hr>
        <div class="text-center mt-4">
          @csrf
          <input type="hidden" name="server_id" value="{{ $server->id }}">
          <input type="submit" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white" value="Delete">
        </div>
      </form>
    @endif
  </div>
</div>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('menu_servers').classList.remove('text-gray-500');
    document.getElementById('menu_servers').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_servers').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_servers').classList.remove('hover:text-gray-100');
    document.getElementById('menu_servers').classList.add('text-gray-100');
    document.getElementById('menu_servers').classList.add('bg-opacity-25');
    document.getElementById('menu_servers').classList.add('bg-gray-700');
  });
</script>
@endsection
 
