@extends('layouts.app')
@section('title') User logs @endsection
@section('content')

<div x-data="{ open: false, zone: '' }">
<div x-cloak
       @keydown.window.escape="open = false"
       x-show="open"
       class="relative z-10"
       aria-labelledby="modal-title"
       x-ref="dialog"
       aria-modal="true">
  
    <div x-show="open"
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-description="Background backdrop, show/hide based on modal state."
         class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
         aria-hidden="true"></div>
  
  
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
      <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
        <div x-show="open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave="ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-description="Modal panel, show/hide based on modal state."
             class="relative transform overflow-hidden rounded-lg border-t-2 border-cyan-600 bg-white dark:bg-slate-800 text-left shadow-xl transition-all my-8 w-full max-w-lg"
             @click.away="open = false">
          <div class="bg-white dark:bg-slate-800 px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
            <div class="flex flex-col items-start">
              <div class="mt-2 w-full text-center sm:text-left text-gray-900 dark:text-white">
                <h3 class="text-lg font-semibold leading-6 text-center"
                    id="modal-title">
                    Log view
                </h3>
                <hr class="border-slate-200 dark:border-slate-700 my-3">
              </div>
              <div class="my-2 w-full overflow-auto py-2 text-slate-900 dark:text-slate-200" id="log">
                
              </div>
            </div>
          </div>
        </div>
  
      </div>
    </div>
  </div>


<div class="flex gap-3 flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 justify-between h-fit border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
    <div class="overflow-x-auto text-slate-900 dark:text-slate-400">
    @if ($userlogs == null)
    {{ __('No logs found') }}
    @else
    <table id="table_logs" class="border-collapse table-auto w-full h-full text-base">
      <thead>
        <tr class="text-center">
          <th class="p-4 font-medium">{{ __('User name') }}</th>
          <th class="p-4 font-medium">{{ __('Action') }}</th>
          <th class="p-4 font-medium">{{ __('IP') }}</th>
          <th class="p-4 font-medium">{{ __('Time') }}</th>
          <th class="p-4 font-medium">{{ __('Data') }}</th>
        </tr>
      </thead>
      <tbody>
      @foreach($userlogs as $log)
        <tr class="text-center border-slate-200 dark:border-slate-600 border-y">
        <td class="p-1">{{ $log->username }} </td>
        <td class="p-1">{{ $log->action }}</td>
        <td class="p-1">{{ $log->ip }}</td>
        <td class="p-1">{{ \Carbon\Carbon::parse($log->timestamp) }}</td>
        <td class="p-1"><button  x-on:click="open=true; showLog($el.dataset.values);" data-values="{{ $log->value }}" class="px-2 py-1 text-xs text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">View</button></td>
        </tr>
      @endforeach
      </tbody>
    </table>
    @endif
    </div>
  </div>
</div>

</div>

<script>

  const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_logs').classList.remove('text-gray-500');
    document.getElementById('menu_logs').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_logs').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_logs').classList.remove('hover:text-gray-100');
    document.getElementById('menu_logs').classList.add('text-gray-100');
    document.getElementById('menu_logs').classList.add('bg-opacity-25');
    document.getElementById('menu_logs').classList.add('bg-gray-700');
    document.getElementById('menu_user_logs').classList.remove('text-gray-500');
    document.getElementById('menu_user_logs').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_user_logs').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_user_logs').classList.remove('hover:text-gray-100');
    document.getElementById('menu_user_logs').classList.add('text-gray-100');
    document.getElementById('menu_user_logs').classList.add('bg-opacity-25');
    document.getElementById('menu_user_logs').classList.add('bg-gray-700');
    document.getElementById('menu_user_logs').classList.add('border-e-2');
    document.getElementById('menu_user_logs').classList.add('border-indigo-400');
    window.dispatchEvent(new CustomEvent('open-logs-menu'));
    logs_table = new DataTable("#table_logs",
      {
        perPage: 30,
        perPageSelect: [30, 100, 500, ["All", 0]],
        columns: [
          {
            select: 3,
            type: "date",
            format: "MYSQL",
            sort: "desc"
          }
        ]
      });

  });

  function showLog(data)
  {
    var data = JSON.parse(data);
    var output = `<table class="table-auto w-full font-mono"><thead><tr><th>Key</th><th>Value</th></thead><tbody>`;
    Object.keys(data).forEach(function (key) {
      if (typeof data[key] === 'object')
        output += `<tr><td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm">${key}:</td><td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm">${JSON.stringify(data[key])}</td></tr>`;
      else
        output += `<tr><td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm">${key}:</td><td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm">${data[key]}</td></tr>`;
    });
    output += `</tbody></table>`;
    document.getElementById('log').innerHTML = output;
  }
</script>
@endsection
