@extends('layouts.app')
@section('title') Dashboard @endsection
@section('content')

    <div class="flex flex-row max-lg:flex-col mt-4 gap-4 justify-between animate-slide-up-fade-in">
      @if (count($servers_agents) + count($servers_nodes) === 0)
        <div class="flex-1 border-l-2 border-orange-400 p-4 rounded-md hover:shadow-md hover:transition-all text-center bg-white dark:bg-slate-900">
          <p>No servers were found.</p>
          <p>
            <a href="{{ route('add-server') }}"
              class="inline-flex items-center  px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5 me-2">
                <path d="M10.75 4.75a.75.75 0 0 0-1.5 0v4.5h-4.5a.75.75 0 0 0 0 1.5h4.5v4.5a.75.75 0 0 0 1.5 0v-4.5h4.5a.75.75 0 0 0 0-1.5h-4.5v-4.5Z" />
              </svg>
              Add a server to your setup
            </a>
          </p>
        </div>
      @else
        @if (count($servers_agents) > 0)
          <div class="flex-1 border-l-4 border-indigo-400 px-2 py-10 rounded-md flex-col bg-indigo-100/50 dark:bg-slate-900 shadow-md hover:shadow-lg hover:transition-all">
              <div class="text-center">
                <h3 class="text-3xl font-medium">Agents</h3>
              </div>
              <div class="overflow-x-auto">
                <table class="border-collapse table-auto w-full text-sm">
                  <thead>
                    <tr>
                      <th class="font-medium p-2 text-left">Server name</th>
                      <th class="font-medium p-2 text-left">Last seen</th>
                      <th class="font-medium p-2 text-left">Zones / excluded</th>
                      <th class="font-medium p-2 text-left">RBL Status</th>
                      <th class="font-medium p-2 text-left">Cluster</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($servers_agents as $server)
                      <tr class="border-y border-indigo-200 dark:border-slate-800">
                        <td class="p-2">{{ $server->name }} @if ($server->version) <span class="text-xs px-2 rounded-full bg-slate-200 dark:bg-slate-900 underline decoration-indigo-500/50 border border-indigo-900">v{{ $server->version }}</span> @endif</td>
                        <td class="p-2"><span class="before:inline-block before:w-2 before:h-2 before:mr-1 before:rounded-full {{ ($server->last_login === null) ? 'before:bg-gray-500' : (($server->getBoolLastSeen()) ? 'before:bg-green-500' : 'before:bg-red-500' )}}">{{ ($server->last_login) !== null ? "{$server->getDiffForHumans()} ago" : 'Inactive' }}</span></td>
                        <td class="p-2">{{ $server->zones_count }} / <span class="text-orange-700 dark:text-orange-400">{{ $server->getAgentExcludedZonesCount() }}</span></td>
                        @if($server->isBlacklisted()->code == 0)
                          <td class="p-2">@if($server->isBlacklisted()->blacklisted ) <a href="{{ route('blacklist-reports') }}" class="py-1 px-2 text-xs font-medium text-red-900 bg-white border rounded-md border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-red-400 dark:hover:bg-gray-700">Listed</a> @else {{ _('Clean') }} @endif @if(!$server->isBlacklisted()->isRecent) (last check {{ $server->isBlacklisted()->timestamp }}) @endif</td>
                        @else
                          <td class="p-2">N/A</td>
                        @endif
                        <td class="p-2">{{ $server->getCluster() }}</td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div> 
          </div> <!-- Agent card -->
        @endif
        @if (count($servers_nodes) > 0)
          <div class="flex-1 border-l-4 border-indigo-400 px-2 py-10 rounded-md flex-col bg-indigo-100/50 dark:bg-slate-900 shadow-md hover:shadow-lg hover:transition-all">
            <div class="text-center">
              <h3 class="text-3xl font-medium">Nodes</h3>
            </div>
            <div class="overflow-x-auto">
              <table class="border-collapse table-auto w-full text-sm">
                <thead>
                  <tr>
                    <th class="font-medium p-2 text-left">Server name</th>
                    <th class="font-medium p-2 text-left">Last seen</th>
                    <th class="font-medium p-2 text-left">Zones</th>
                    <th class="font-medium p-2 text-left">RBL Status</th>
                    <th class="font-medium p-2 text-left">Cluster</th>
                  </tr>
                </thead>
                <tbody class="">
                  @foreach ($servers_nodes as $server)
                    <tr class="border-y border-indigo-200 dark:border-slate-800">
                      <td class="dark:border-slate-600 p-2">{{ $server->name }} @if ($server->version) <span class="text-xs px-2 rounded-full bg-slate-200 dark:bg-slate-900 underline decoration-indigo-500/50 border border-indigo-900">v{{ $server->version }}</span> @endif</td>
                      <td class="dark:border-slate-600 p-2"><span class="before:inline-block before:w-2 before:h-2 before:mr-1 before:rounded-full {{ ($server->last_login === null) ? 'before:bg-gray-500' : (($server->getBoolLastSeen()) ? 'before:bg-green-500' : 'before:bg-red-500' )}}">{{ ($server->last_login) !== null ? "{$server->getDiffForHumans()} ago" : 'Inactive' }}</span></td>
                      <td class="dark:border-slate-600 p-2">{{ $server->zones_count }}</td>
                      @if($server->isBlacklisted()->code == 0)
                        <td class="dark:border-slate-600 p-2">@if($server->isBlacklisted()->blacklisted) <a href="{{ route('blacklist-reports') }}" class="py-1 px-2 text-xs font-medium text-red-900 bg-white border rounded-md border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-red-400 dark:hover:bg-gray-700">Listed</a> @else {{ _('Clean') }} @endif @if(!$server->isBlacklisted()->isRecent) (last check {{ $server->isBlacklisted()->timestamp }}) @endif</td>
                      @else
                        <td class="dark:border-slate-600 p-2">N/A</td>
                      @endif
                      <td class="dark:border-slate-600 p-2">{{ $server->getCluster() }}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div><!-- nodes cards -->
        @endif
      @endif
      </div>
      <hr class="border-slate-200 dark:border-slate-700 my-5">
      <!-- logs/problems row -->
      <div class="flex mb-10 flex-row max-md:flex-col flex-wrap mt-4 justify-stretch gap-4 animate-slide-up-fade-in">
        <div class="flex-none flex-col bg-white dark:bg-slate-900  rounded-md shadow-md p-4 hover:shadow-lg hover:transition-all">
          <div class="">
            <div class="p-2 text-center">
              <h3 class="text-2xl font-medium">
                Latest logs
              </h3>
            </div>
            <div class="mt-2">
              @if (count($logs) === 0)
                {{ __('No logs found') }}
              @else
                <table class="border-collapse table-auto w-full text-sm">
                  @foreach ($logs as $log)
                    <tr class="border-y dark:border-slate-600" data-toggle="tooltip" data-placement="top" title="{{ $log->server_name }}">
                      <td class="p-1">{{ $log->action }}</td>
                      <td class="p-1">{{ $log->zone }}</td>
                      <td class="p-1">{{ $log->timestamp }}</td>
                    </tr>
                  @endforeach
                </table>
              @endif
            </div>
          </div>
        </div>
          <div class="grow p-4 justify-between border-l-2 @if($rbl_check->blacklisted) border-red-400 dark:border-red-700 bg-red-500/5 @else border-green-400 bg-green-500/5 @endif h-fit rounded-md shadow-md hover:shadow-lg hover:transition-all">
            <div class="p-5 text-center">
              <h3 class="text-xl font-medium">
                RBL Status
              </h3>
            </div>
            <hr class="border-slate-200 dark:border-slate-700"></hr>
            <div class="mt-3">
              @if ($rbl_check->blacklisted)
                  Listed servers:
                  <ul class="leading-relaxed list-inside list-disc text-sm ml-4">
                  @foreach($rbl_check->primary_servers as $srv)
                    <li>{{ $srv }}</li>
                  @endforeach
                  @foreach($rbl_check->additional_servers as $srv)
                    <li>{{ $srv }}</li>
                  @endforeach
                  </ul>
              @else
                <div class="text-center">
                  <span class="text-xs">Your servers are not listed in any RBL.</span>
                </div>
              @endif
            </div>
            <div class="mt-10 flex items-center justify-center gap-x-6">
              <a class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700"
                href="{{ route('blacklist-reports') }}">
                See reports
                <svg class="w-4 h-4 ms-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                  stroke="currentColor" class="size-6">
                  <path stroke-linecap="round" stroke-linejoin="round" d="M17.25 8.25 21 12m0 0-3.75 3.75M21 12H3" />
                </svg>
              </a>
            </div>
          </div>
          <div class="grow h-fit border-l-2 @if(count($faulty_clusters) > 0) border-red-400 dark:border-red-700 bg-red-500/5 @else border-green-400 bg-green-500/5 @endif flex-col rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
            <div class="p-5 text-center">
              <h3 class="text-2xl font-medium">
                <span>Issues</span>
              </h3>
            </div>
            <hr class="border-slate-200 dark:border-slate-700">
            <div class="mt-2 ">
              @if (count($faulty_clusters) > 0)
                <ul class="leading-relaxed">
                  @foreach ($faulty_clusters as $cluster)
                    <li><span class="bg-orange-400 dark:bg-orange-700 rounded-lg px-3 text-slate-900 dark:text-slate-200">{{ $cluster->name }}</span>
                      <ul class="ml-4 list-inside list-disc text-sm leading-relaxed ps-2 my-2 border-s-2 border-red-700">
                      @foreach ($cluster->isFaulty()->reasons as $reason)
                        <li>{!! $reason !!}</li>
                      @endforeach
                      </ul>
                    </li>
                  @endforeach 
                </ul>
              @else
                <div class="text-center">
                  <span class="text-sm">No problems found</span>
                </div>
              @endif
            </div>
          </div> <!-- problems card -->
          <div class="flex-none h-fit flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
            <div class="p-5 text-center">
              <h3 class="text-2xl font-medium">
                Stats
              </h3>
            </div>
            <hr class="border-slate-200 dark:border-slate-700">
            <table class="mt-4 border-collapse table-auto w-full text-sm">
              <tbody>
                <tr>
                  <td class="border-r dark:border-slate-600 font-medium p-4"><span class="inline-block align-middle">User count</span></td>
                  <td class="p-4"><span class="inline-block align-middle">{{ $user_count }}</span></td>
                </tr>
                <tr>
                  <td class="border-r border-t dark:border-slate-600 font-medium p-4 "><span class="inline-block align-middle">Server count</span></td>
                  <td class="p-4 "><span class="inline-block align-middle">{{ $servers_agents->count() + $servers_nodes->count() }}</span></td>
                </tr>
                <tr>
                  <td class="border-r border-t dark:border-slate-600 font-medium p-4"><span class="inline-block align-middle">Zone count</span></td>
                  <td class="p-4"><span class="inline-block align-middle">{{ $zone_count }}</span></td>
                </tr>
              </tbody>
            </table>
        </div>
       
      </div> <!-- logs and others flex -->
      <div class="flex flex-col xl:flex-row gap-4 my-4 justify-between w-full animate-slide-up-fade-in"> <!-- Stats section -->
        <div class="flex-1 flex-col h-fit bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
          <div>
            <h3 class="text-xl font-medium text-center">
              Zone count <small>per server</small>
            </h3>
          </div>
          <div id="zones_chart">

          </div>
        </div>
        <div class="flex-1 h-fit bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
          <div>
            <h3 class="text-xl font-medium text-center">
              Zone additions/removals <small>last 6 months</small>
            </h3>
          </div>
          <div id="inserts_deletes_graph">

          </div>
        </div>
      </div> <!-- End stats section -->
      <script>
        document.addEventListener('DOMContentLoaded', function () {
          document.getElementById('menu_home').classList.remove('text-gray-500');
          document.getElementById('menu_home').classList.remove('hover:bg-gray-700');
          document.getElementById('menu_home').classList.remove('hover:bg-opacity-25');
          document.getElementById('menu_home').classList.remove('hover:text-gray-100');
          document.getElementById('menu_home').classList.add('text-gray-100');
          document.getElementById('menu_home').classList.add('bg-opacity-25');
          document.getElementById('menu_home').classList.add('bg-gray-700');
          document.getElementById('menu_home').classList.add('border-e-2');
          document.getElementById('menu_home').classList.add('border-indigo-400');
          var chart_agent_zones = new ApexCharts(document.querySelector("#zones_chart"), options);
          chart_agent_zones.render();
          charts.push(chart_agent_zones);
          var inserts_deletes_graph = new ApexCharts(document.querySelector("#inserts_deletes_graph"), inserts_deletes_graph_options);
          inserts_deletes_graph.render();
          charts.push(inserts_deletes_graph);
        });
        charts = [];
        var options = {
          chart: {
            id: 'zone_count',
            background: 'rgba(0,0,0,0)',
            type: 'bar',
            toolbar: {
              show: false
            }
        },
        plotOptions: {
          bar: {
            horizontal: true,
            barHeight: '50%',
            borderRadius: 5,
            borderRadiusApplication: 'end'
          }
        },
        theme: {
          mode: localStorage.theme,
          palette: 'palette2',
        },
        series: [{
        name: 'Zones',
        data: [@foreach($agents_zone_count as $agent) {{ $agent->zones_count}}, @endforeach]
        }],
        xaxis: {
        categories: [@foreach($agents_zone_count as $agent) '{{$agent->name}}', @endforeach]
        }

        }
        var inserts_deletes_graph_options = {
          chart:{
            id: 'inserts_deletes',
            background: 'rgba(0,0,0,0)',
            type: 'area',
            toolbar: {
              show: false
            },
          },
          fill: {
            gradient: {
              enabled: true,
              opacityFrom: 0.55,
              opacityTo: 0
            },
          },
          series: [
            {
              name: "Inserts",
              data: [@foreach($inserts_deletes_graph as $data) {{ $data->count_insert }}, @endforeach]
            },
            {
              name: "Deletes",
              data: [@foreach($inserts_deletes_graph as $data) {{ $data->count_delete }}, @endforeach]
            }
          ],
          xaxis: {
            categories: [
              @foreach($inserts_deletes_graph as $data) '{{ $data->year }} {{ $data->monthname }}', @endforeach
            ]
          },
          theme: {
            mode: localStorage.theme,
            palette: 'palette2',
          },
          colors: [
            "#009900",
            "#990000"
          ],
          stroke: {
            width: 2,
            curve: 'smooth',
            lineCap: 'round',
          },
          markers: {
            size: 4,
            colors: ["#00AA00", "#AA0000"],
            strokeWidth: 3
          },
          dataLabels: {
            enabled: false
          },
          plotOptions: {
          }
        };
       
      </script>
@endsection
