@extends('layouts.app')
@section('title') Delete cluster @endsection
@section('content')
<div class="flex flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-lg px-4 py-10 drop-shadow-md">
    @if (!$cluster)
    <div class="rounded bg-orange-100 p-4 mb-4 text-orange-700 md:p-5 dark:bg-orange-900/75 dark:text-orange-100 animate-slide-up-fade-in">
      <div class="mb-2 flex items-center">
        <h3 class="font-semibold">Error!</h3>
      </div>
      <p class="ml-8">
        Cluster not found.
      </p>
    </div>
    @else
      @if ($servers_count == 0)
        <form class="text-center" method="POST" action="">
          @csrf
          <input type="submit" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white" value="Delete cluster {{ $cluster->name }}">
        </form>
      @else
      <div class="rounded  p-4 mb-4 bg-orange-100 text-orange-700 md:p-5 dark:bg-orange-800 dark:text-orange-100 animate-slide-up-fade-in">
        <div class="mb-2 flex items-center">
          <h3 class="font-semibold">Error!</h3>
        </div>
        <p class="ml-8">
          You have to manually remove all servers in this cluster before deleting this cluster.
        </p>
      </div>
      @endif
    @endif
  </div>
</div>
@endsection
 
