@extends('layouts.app')
@section('title') Settings @endsection
@section('content')

<div x-data="{ open: false, info: ''}">
 <div x-cloak
  @keydown.window.escape="open = false"
  x-show="open"
  class="relative z-10"
  aria-labelledby="modal-title"
  x-ref="dialog"
  aria-modal="true">

   <div x-show="open"
    x-transition:enter="ease-out duration-300"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="ease-in duration-200"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    x-description="Background backdrop, show/hide based on modal state."
    class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
    aria-hidden="true"></div>


   <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
    <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
     <div x-show="open"
      x-transition:enter="ease-out duration-300"
      x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
      x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
      x-transition:leave="ease-in duration-200"
      x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
      x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
      x-description="Modal panel, show/hide based on modal state."
      class="relative transform overflow-hidden rounded-md border-t-2 border-teal-600 bg-white dark:bg-slate-900 text-left shadow-xl transition-all my-8 w-full max-w-lg"
      @click.away="open = false">
       <div class="bg-white dark:bg-slate-900 px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
        <div class="sm:flex sm:flex-col sm:items-start">
         <div class="sm:flex sm:flex-row items-center w-full">
          <div class="mt-3 w-full text-center sm:ml-4 sm:mt-0 sm:text-left text-gray-900 dark:text-white">
           <div class="text-base" x-html="info">
           </div>
          </div>
         </div>
        </div>
       </div>
      </div>
    </div>
   </div>
  </div>

  @if ($errors->any())
  <div class="w-full p-3 my-2 bg-red-300 rounded-md border border-black dark:border-white dark:text-slate-900 animate-slide-up-fade-in text-center">
   <ul>
    @foreach ($errors->all() as $error)
    <li>{{ $error }}</li>
    @endforeach
   </ul>
  </div>
  @endif
  @if (Request()->message)
  <div class="w-full p-3 my-2 rounded-md border border-black dark:border-white animate-slide-up-fade-in text-center">
   {{ Request()->message }}
  </div>
  @endif

  <form method="POST"
   action="">
    <div x-data="{ show_version: false, current_version: ''}"
     x-on:show-version.window="show_version=true;render_current_version()"
     class="flex gap-3 flex-col my-4 animate-slide-up-fade-in">
      <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md shadow-md p-4 hover:shadow-lg hover:transition-all">
       <div class="text-2xl font-semibold mb-3">
        General settings
       </div>
       <div class="grid lg:grid-cols-2 gap-3">
        <div class="grid gap-3">
         <div>
          <div class="block font-medium">
           <label for="last_seen"
            class="">Last seen threshold in minutes</label> (<span x-on:click="open=true; info=$el.attributes.title.value;"
             class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
             title="Start sending notifications after X minutes of a server going offline.">?</span>):
          </div>
          <input id="last_seen"
           class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-fit p-2.5  mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
           type="number"
           name="last_seen"
           value="{{ $last_seen->getValue() }}"
           placeholder="Last seen limit"
           required
           autofocus>
         </div>
        </div>
        <div>
         <div class="grid gap-3 mt-3">
          <div>
           <input type="checkbox"
            name="hide_single_server_zones_in_dup_list"
            id="hide_single_server_zones_in_dup_list"
            {{ $hide_single_server_zones_in_dup_list ? ($hide_single_server_zones_in_dup_list->value_bool ? 'checked' : '') : '' }}>
           <label for="hide_single_server_zones_in_dup_list"
            class="font-medium">
             Hide zones that are active only in one server on Duplicate Zones list
            </label>
          </div>

          <div>
           <input type="checkbox"
            id="disable_zones_complete_load"
            name="disable_zones_complete_load"
            {{ $disable_zones_complete_load ? ($disable_zones_complete_load->value_bool ? 'checked' : '') : '' }}>
           <label for="disable_zones_complete_load"
            class="font-medium">
             Disable zones complete load</label> (<span x-on:click="open=true; info=$el.attributes.title.value;"
              class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
              title="Use this if the number of zones is very big and loading is slow. This will let you search for a zone instantly on the zones page.">?</span>)
          </div>
         </div>

         <div class="grid gap-3 mt-3">
          <div>
           <input type="checkbox"
            id="dnstool_use_external_resolvers"
            name="dnstool_use_external_resolvers"
            {{ $dnstool_use_external_resolvers ? ($dnstool_use_external_resolvers->value_bool ? 'checked' : '') : '' }}>
           <label for="dnstool_use_external_resolvers"
            class="font-medium">
             Include external resolvers during DNS Diagnosis tool usage</label> (<span x-on:click="open=true; info=$el.attributes.title.value;"
              class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
              title="1.1.1.1 & 8.8.8.8 will also be used during diagnosis.">?</span>)
          </div>
         </div>
        </div>
       </div>


      </div>

      <!-- Auto-Exclude Settings -->
      <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
       <div class="text-2xl font-semibold mb-3">
        Auto-Exclude settings
        (<span x-on:click="open=true; info=$el.attributes.title.value;"
         class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
         title="This is a security setting that supports cPanel, DirectAdmin, Plesk & Virtualmin panels.<br/>If 'userA' creates a zone named 'zone.com' and 'userB' attempts to create a 'sub.zone.com' subdomain the subdomain will be auto-excluded to prevent unauthorized takeover.">?</span>)
       </div>
       <div class="grid gap-3">
        <div>
         <input type="checkbox" id="auto_exclude_feature" name="auto_exclude_feature" {{ $auto_exclude_feature ? ($auto_exclude_feature->value_bool ? 'checked' : '') : '' }}>
         <label for="auto_exclude_feature"
          class="font-medium">
           Enable Auto-Exclude feature
          </label>
        </div>
        <div class="grid lg:grid-cols-2 gap-2">
         <div>
          <label for="auto_exclude_feature_domains" class="block font-medium">Domain ignore list:</label>
          <textarea name="auto_exclude_feature_domains" class="w-full border border-slate-700 dark:border-slate-200 dark:bg-slate-700 p-3 mt-2 font-mono text-xs rounded-md" id="auto_exclude_feature_domains" rows="5" placeholder="Comma separated domains to exempt in auto-exclude feature. e.g.: zone.cloud,zonecloud.tld">@if($auto_exclude_feature_domains){{$auto_exclude_feature_domains->value_text}}@endif</textarea>
         </div>
         <div>
          <label for="auto_exclude_feature_usernames" class="block font-medium">Username ignore list:</label>
          <textarea name="auto_exclude_feature_usernames" class="w-full border border-slate-700 dark:border-slate-200 dark:bg-slate-700 p-3 mt-2 font-mono text-xs rounded-md" id="auto_exclude_feature_usernames" rows="5" placeholder="Comma separated users to exempt in auto-exclude feature. e.g.: user1,user2">@if($auto_exclude_feature_usernames){{$auto_exclude_feature_usernames->value_text}}@endif</textarea>
         </div>
        </div>
       </div>
      </div>

      <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
       <div class="text-2xl font-semibold mb-3">
        Notification settings
       </div>
       <div class="grid lg:grid-cols-3 gap-3 items-center">

        <div class="">
         <input type="checkbox"
          id="email_notifications"
          name="email_notifications"
          @if ($email_notifications->getValue())
           {{ __('checked') }}
           @endif>
          <span class="font-medium">
           <label for="email_notifications"
            class="">
             Email notifications</label> (<span x-on:click="open=true; info=$el.attributes.title.value;"
              class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
              title="Enable/Disable email notifications.">?</span>)
          </span>
        </div>
        <div>
         <span class="block font-medium">
          <label for="suppress_sync_notifications_threshold">Zones sync notifications threshold </label>(<span x-on:click="open=true; info=$el.attributes.title.value;" class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white" title="Suppress zone number mismatch notifications if less than X minutes passed since last zone alter. This helps eliminate false notifications for zone number mismatches between nodes and clusters. Defaults to 10 minutes.">?</span>)
         </span>
         <input id="suppress_sync_notifications_threshold" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-fit p-2.5  mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" type="number" name="suppress_sync_notifications_threshold" value="{{ $suppress_sync_notifications_threshold ? ($suppress_sync_notifications_threshold->value_int ? $suppress_sync_notifications_threshold->value_int : '10') : '10' }}" placeholder="Zones sync notifications threshold" required>
        </div>
       </div>

       <div class="grid lg:grid-cols-2 gap-2 mt-2">
        <div class="border border-gray-300 rounded-md block w-full p-2.5  mt-2 dark:border-gray-600">
         <div class="grid gap-2">
          <div class="text-xl font-semibold mb-3">
           Fine-grained email notifications
          </div>
          <div>
           <label for="notifications_recipient"
            class="block font-medium">Notifications recipient:</label>
           <input id="notifications_recipient"
            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5 mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
            type="text"
            name="notifications_recipient"
            placeholder="e.g. alerts@mydomain.com"
            value="{{ $notifications_recipient->getValue() }}">
          </div>
          <div>
           <input type="checkbox" name="email_error_reports" id="email_error_reports" {{ $email_error_reports ? ($email_error_reports->value_bool ? 'checked' : '') : '' }}>
           <label for="email_error_reports" class="font-medium">Enable error reporting</label>
          </div>
          <div>
           <input type="checkbox" name="email_latest_logs" id="email_latest_logs" {{ $email_latest_logs ? ($email_latest_logs->value_bool ? 'checked' : '') : '' }}>
           <label for="email_latest_logs" class="font-medium">Receive notifications for zones inserted / deleted / excluded</label>
          </div>
         </div>
        </div>
        <div class="border border-gray-300 rounded-md block w-full p-2.5  mt-2 dark:border-gray-600">
         <div class="grid gap-2">
          <div class="text-xl font-semibold mb-3">
           Slack notifications settings
          </div>
          <div>
           <div class="block font-medium">
            <label for="slack_url"
             class="">Slack URL </label>(<span x-on:click="open=true; info=$el.attributes.title.value;"
              class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
              title="Slack URL to send notifications. Leave empty if you don't want slack notifications.">?</span>):
           </div>
           <input id="slack_url"
            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5 mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
            type="text"
            name="slack_url"
            placeholder="https://hooks.slack.com/services/TXXXX/BYYYY/ZZZZ"
            value="{{ $slack_url ? ($slack_url->value_text ? $slack_url->value_text : '') : '' }}">
          </div>
          <div>
           <input type="checkbox" name="slack_error_reports" id="slack_error_reports" {{ $slack_error_reports ? ($slack_error_reports->value_bool ? 'checked' : '') : '' }}>
           <label for="slack_error_reports" class="font-medium">Enable error reporting</label>
          </div>
          <div>
           <input class="form-check-input" type="checkbox" name="slack_latest_logs" id="slack_latest_logs" {{ $slack_latest_logs ? ($slack_latest_logs->value_bool ? 'checked' : '') : '' }}>
           <label for="slack_latest_logs" class="font-medium">Receive notifications for zones inserted / deleted / excluded</label>
          </div>
         </div>
        </div>

        <div class="border border-gray-300 rounded-md block w-full p-2.5  mt-2 dark:border-gray-600">
         <div class="grid gap-2">
          <div class="text-xl font-semibold mb-3">
           Webhook notifications settings
          </div>
          <div>
           <div class="block font-medium">
            <label for="webhook_url"
             class="">Webhook URL</label>(<span x-on:click="open=true; info=$el.attributes.title.value;"
              class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
              title="Webhook URL to send notifications to. Leave empty if you don't want webhook notifications.">?</span>):
           </div>
           <input id="webhook_url"
            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5 mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
            type="text"
            name="webhook_url"
            placeholder="https://app.webhookservice.tld/ac8f2d6b-75bc-4005-8532-772e9c51396c"
            value="{{ $webhook_url ? ($webhook_url->value_text ? $webhook_url->value_text : '') : '' }}">
          </div>
          <div>
           <input type="checkbox" name="webhook_error_reports" id="webhook_error_reports" {{ $webhook_error_reports ? ($webhook_error_reports->value_bool ? 'checked' : '') : '' }}>
           <label for="webhook_error_reports" class="font-medium">Enable error reporting</label>
          </div>
          <div>
           <input class="form-check-input" type="checkbox" name="webhook_latest_logs" id="webhook_latest_logs" {{ $webhook_latest_logs ? ($webhook_latest_logs->value_bool ? 'checked' : '') : '' }}>
           <label for="webhook_latest_logs" class="font-medium">Receive notifications for zones inserted / deleted / excluded</label>
          </div>
         </div>
        </div>

       </div>
      </div>

      <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
       <div class="text-2xl font-semibold mb-3">
        Reverse proxy settings (<span x-on:click="open=true; info=$el.attributes.title.value;"
         class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
         title="Enable the following option if your controller sits behind a proxy server and a custom header is needed to determine the visitor's real IP. Specify the custom header that the proxy server appends to the HTTP request.">?</span>)
       </div>
       <div class="grid lg:grid-cols-2 gap-2">
        <div>
         <input type="checkbox"
          id="reverse_proxy_header_enabled"
          {{ $reverse_proxy_header_enabled ? ($reverse_proxy_header_enabled->value_bool ? 'checked' : '') : '' }}
          name="reverse_proxy_header_enabled">
         <label for="reverse_proxy_header_enabled" class="">
          Use custom HTTP header to determine visitor's IP
         </label>
         <div>
          Current visitor determined IP: <span class="font-semibold">{{  request()->ip() }}</span>
         </div>
        </div>
        <div>
         <label for="reverse_proxy_header"
          class="block font-medium">
           Custom HTTP header:
          </label>
          <input id="reverse_proxy_header"
           class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5 mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
           type="text"
           name="reverse_proxy_header"
           placeholder="e.g. X-Real-IP"
           value="{{ $reverse_proxy_header ? (!empty($reverse_proxy_header->value_text) ? $reverse_proxy_header->value_text : '') : '' }}">
        </div>
       </div>
      </div>
      <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
       <div class="text-2xl font-semibold mb-3">
        RBL settings
       </div>
       <div class="grid lg:grid-cols-2 gap-2">
        <div>
         <label for="blacklists" class="block font-medium">Blacklists:</label>
         <textarea id="blacklists" name="blacklists" class="w-full border border-slate-700 dark:border-slate-200 dark:bg-slate-700 p-3 mt-2 font-mono text-xs rounded-md" rows="5" placeholder="e.g.: cbl.abuseat.org,zen.spamhaus.org">@if ($blacklists){{ $blacklists->value_text }}@endif</textarea>
        </div>
        <div>
         <label for="additional_servers" class="block font-medium">Additional servers:</label>
         <textarea id="additional_servers" name="additional_servers" class="w-full border border-slate-700 dark:border-slate-200 dark:bg-slate-700 p-3 mt-2 font-mono text-xs rounded-md" rows="5" placeholder="<Server name>:<IP> list. e.g.: server1:123.123.123.123,server2:213.213.213.213">@if ($additional_servers){{ $additional_servers->value_text }}@endif</textarea>
        </div>
       </div>
      </div>
      <div class="grid lg:grid-cols-2 gap-3">
       <div class="flex-1 justify-between h-full border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
        <div class="text-2xl font-semibold mb-3">
         Updates
        </div>
        <div class="grid gap-2">
         <div x-cloak
          x-show="show_version">
           <span>Current version <span x-on:render-version.window="current_version=$event.detail.version" x-text="current_version" class="px-2 rounded-full bg-slate-200 dark:bg-slate-700 underline decoration-indigo-500/50"></span></span>
          </div>
          <div x-on:update-result.window="if($event.detail.update_available){show_update_button=true;version=$event.detail.version;show_check_update_button=false}else{show_no_update_available=true}" x-data="{show_update_button: false, show_check_update_button: true, show_no_update_available: false, version: ''}">
           <button x-show="show_check_update_button" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700" id="update_btn" type="button" onclick="check_for_updates()">Check for updates</button>
           <span x-show="show_update_button" class="animate-slide-up-fade-in">Update to <span x-text="version" class="px-2 rounded-full bg-slate-200 dark:bg-slate-700 underline decoration-emerald-500/50"></span> available. <a href="/settings/update_controller" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">Update</a></span>
           <span x-show="show_no_update_available" class="animate-slide-up-fade-in">No update available.</span>
          </div>
        </div>
       </div>

       <div class="flex-1 justify-between h-full border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
        <div class="text-2xl font-semibold mb-3">
         License status
        </div>
        <div class="text-center">
         @if ($license_data === false)
         Can't get license data.
         @else
         <table class="table-auto w-full">
          <tbody>
           <tr>
            <th class="border-b dark:border-slate-600 font-medium p-1">Status</th>
            <td class="border-b dark:border-slate-600 p-1">{{ $license_data->status }}</td>
           </tr>
           <tr>
            <th class="border-b dark:border-slate-600 font-medium p-1">Registered to</th>
            <td class="border-b dark:border-slate-600 p-1">{{ $license_data->registeredname }}</td>
           </tr>
           <tr>
            <th class="border-b dark:border-slate-600 font-medium p-1">Expiry date</th>
            <td class="border-b dark:border-slate-600 p-1">{{ $license_data->nextduedate }}</td>
           </tr>
           <tr>
            <th class="border-b dark:border-slate-600 font-medium p-1">Last contact with license server</th>
            <td class="border-b dark:border-slate-600 p-1">{{ DateTime::createFromFormat('Ymd', $license_data->checkdate)->format('Y-m-d') }}</td>
           </tr>
           <tr>
            <th class="border-b dark:border-slate-600 font-medium p-1">Next scheduled contact with license server</th>
            <td class="border-b dark:border-slate-600 p-1">{{ DateTime::createFromFormat('Ymd', $license_data->checkdate + 1)->format('Y-m-d') }}</td>
           </tr>
           <tr>
            <th class="border-b dark:border-slate-600 font-medium p-1">Local license active until (<span x-on:click="open=true; info=$el.attributes.title.value;"
             class="cursor-help items-center justify-center relative inline-flex text-sm w-5 h-5 font-bold rounded-full bg-gray-300 border border-black text-black dark:border-white dark:bg-black dark:text-white"
             title="If for some reason your controller can't reach the license server (e.g. temporary connection issues), there will be a 3 days grace period since the last contact that your license will remain active.">?</span>)</th>
            <td class="border-b dark:border-slate-600 p-1">{{ DateTime::createFromFormat('Ymd', $license_data->checkdate + 3)->format('Y-m-d') }}</td>
           </tr>
          </tbody>
         </table>
         @endif
        </div>
       </div>
      </div>
      @csrf
     </div>
     <div class="text-center mb-3">
      <button type="submit" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">Save</button>
     </div>

   </form>
</div>
<script>
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
document.addEventListener('DOMContentLoaded', function () {
 document.getElementById('menu_settings').classList.remove('text-gray-500');
 document.getElementById('menu_settings').classList.remove('hover:bg-gray-700');
 document.getElementById('menu_settings').classList.remove('hover:bg-opacity-25');
 document.getElementById('menu_settings').classList.remove('hover:text-gray-100');
 document.getElementById('menu_settings').classList.add('text-gray-100');
 document.getElementById('menu_settings').classList.add('bg-opacity-25');
 document.getElementById('menu_settings').classList.add('bg-gray-700');
 document.getElementById('menu_settings').classList.add('border-e-2');
 document.getElementById('menu_settings').classList.add('border-indigo-400');

 window.dispatchEvent(new CustomEvent('show-version'));
});

function check_for_updates()
{
 fetch('/settings/update_check', {
  method: 'GET',
  headers: {
   'X-CSRF-TOKEN': csrfToken,
   'Content-Type': 'application/json'
  }
 })
 .then(response => response.json())
 .then(response => {

  if ( response.update_available )
   {
    window.dispatchEvent(new CustomEvent('update-result', { detail: { update_available: response.update_available, version: response.version_available}}));
   }
   else if ( !response.update_available )
    {
     window.dispatchEvent(new CustomEvent('update-result', { detail: { update_available: response.update_available }}));

    }
 });
}

function render_current_version()
{
 fetch('/settings/current_version', {
  method: 'GET',
  headers: {
   'X-CSRF-TOKEN': csrfToken,
   'Content-Type': 'application/json'
  }
 })
 .then(response => response.json())
 .then(response => {
  window.dispatchEvent(new CustomEvent('render-version', { detail: {version: response.current_version}}));
 });
}
</script>

@endsection
