@extends('layouts.app')
@section('title') Server incidents @endsection
@section('content')

<div class="my-4 grid lg:grid-cols-3 gap-4">
@foreach($incidents as $server)
  <div class="justify-between h-fit  border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all text-slate-900 dark:text-slate-400 animate-slide-up-fade-in">
        <div class="text-center text-lg font-semibold">
          {{ $server->server_name }}
        </div>
        <hr class="border-slate-200 dark:border-slate-700 my-3">
        <div class="text-center">
            @if(count($server->data)>0)
              <table class="table-auto w-full">
                <thead>
                  <tr class="font-medium text-center">
                    <th class="p-1">{{ __('Duration') }}</th>
                    <th class="p-1">{{ __('Start') }}</th>
                    <th class="p-1">{{ __('End') }}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($server->data as $incident)
                    <tr class="border-y border-slate-200 dark:border-slate-600">
                      <td class="p-1 text-sm text-red-700 dark:text-red-300">{{ $incident[0]['duration'] }}</td>
                      <td class="p-1 text-sm">{{ $incident[0]['start'] }}</td>
                      <td class="p-1 text-sm">{{ $incident[0]['stop'] }}</td>
                    </tr> 
                  @endforeach
                </tbody>
              </table>
            @else
              No incidents found
            @endif
        </div>
  </div>
@endforeach
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_logs').classList.remove('text-gray-500');
    document.getElementById('menu_logs').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_logs').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_logs').classList.remove('hover:text-gray-100');
    document.getElementById('menu_logs').classList.add('text-gray-100');
    document.getElementById('menu_logs').classList.add('bg-opacity-25');
    document.getElementById('menu_logs').classList.add('bg-gray-700');
    document.getElementById('menu_server_logs').classList.remove('text-gray-500');
    document.getElementById('menu_server_logs').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_server_logs').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_server_logs').classList.remove('hover:text-gray-100');
    document.getElementById('menu_server_logs').classList.add('text-gray-100');
    document.getElementById('menu_server_logs').classList.add('bg-opacity-25');
    document.getElementById('menu_server_logs').classList.add('bg-gray-700');
    document.getElementById('menu_server_logs').classList.add('border-e-2');
    document.getElementById('menu_server_logs').classList.add('border-indigo-400');
    window.dispatchEvent(new CustomEvent('open-logs-menu'));
});
</script>

@endsection
