@extends('layouts.app')
@section('title')
  <i class="fas fa-history mr-1 mt-1"></i> Logs
@endsection

@section('content')
<div id="dig_modal" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><span id="dig_zone"></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="text-center">
          <div class="btn-group mb-3">
            <button class="btn btn-default" id="a_dig">A records</button>
            <button class="btn btn-default" id="mx_dig">MX records</button>
            <button class="btn btn-default" id="ns_dig">NS records</button>
          </div>
        </div>
        <pre id="dig_result" style="background-color:black;color:white;padding:20px;border-radius:5px;"></pre>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div class="container-fluid pt-3">
  <div class="card">
    <div class="card-body">
      <div class="row mb-3">
        <div class="input-group">
          <input class="form-control" id="query" type="text" name="query" placeholder="Search query" required>
          <span class="input-group-append">
            <button id="btnSearch" class="btn btn-default" type="button">Search</button>
          </span>
        </div>
      </div>
      <table id="table_logs" class="table table-sm table-striped">
        <thead>
          <tr>
            <th>{{ __('Zone') }}</th>
            <th>{{ __('Action') }}</th>
            <th>{{ __('Server') }}</th>
            <th>{{ __('Time') }}</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</div>

<link rel="stylesheet" type="text/css" href="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<script type="text/javascript" src="{{ asset('/css/adminlte-3.0.5/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
$(document).ready(function() {
  $('#menu-logs').addClass('active');
  $('#menu-zones-logs').addClass('active');
  $.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
  });
  var table = $('#table_logs').DataTable(
      {
          "pageLength": 50,
          "order": [[3, "desc"]],
          language:
          {
            search: "Quick filter:",
          },
          columns:
          [
            {
              data: 'zone',
              render: function(data, type, row, meta)
              {
                return data + ' <div class="float-right"><button data-zone="'+ data +'" class="btn btn-xs btn-outline-info dig_btn"><i class="fas fa-terminal mr-1"></i> DNS check</button></div>';
              }
            },
            {data: 'action'},
            {data: 'server_name'},
            {data: 'timestamp'},
          ],
      }
  );

  function search(query)
  {
    $.ajax(
    {
      type: "POST",
      url: "/logs/query",
      data: {query:query},
      success: function(response)
      {
        table.clear();
        table.rows.add(response).draw();
      }
    });
  }
  search("");
  $(document).on('click', '#btnSearch', function()
  {
    search($('#query').val());
  });
  $('#dig_modal').on('click', '#a_dig', function()
  {
      var zone = $('#dig_zone').text();
      var type = 'A';
      getZoneInfo(zone, type);
  });

  $('#dig_modal').on('click', '#mx_dig', function()
  {
      var zone = $('#dig_zone').text();
      var type = 'MX';
      getZoneInfo(zone, type);
  });

  $('#dig_modal').on('click', '#ns_dig', function()
  {
      var zone = $('#dig_zone').text();
      var type = 'NS';
      getZoneInfo(zone, type);
  });


  $('#table_logs').on('click', '.dig_btn', function() {
      var zone = $(this).data('zone');
      $('#dig_zone').html(zone);
      $('#dig_modal')
          .modal('show');
      $('#dig_result').hide();

  });
} );
function getZoneInfo(zone, type)
{
    $.ajax({
        type : 'POST',
        url : '/digcheck',
        data : {zone:zone, type:type},
        beforeSend : function ()
        {
            $('#dig_result').show();
            $('#dig_result').html('<div class="ui active centered inline loader"></div>');
        },
        success : function(response)
        {
            var output = '<table>';
            for (var i = 0; i < response.message.length; i++)
            {
                output = output + '<tr><td>' + Object.keys(response.message[i])[0] + ':</td><td>';
                //output = output +  Object.keys(response.message[i])[0] + " : ";
                for (var key in response.message[i])
                {
                    output = output + ' ' + response.message[i][key];
                    //output = output + response.message[i][key];
                }
                output = output + '</td></tr>';
            }
            output = output + '</table>';
            if (response.code == "ok")
            {
                $('#dig_result').html(output);
            }
            else
            {
                $('#dig_result').html('Command failed.');
            }
        }
    });

}
</script>
@endsection
