@extends('layouts.app')
@section('title')
    <i class="fas fa-sitemap mr-1 mt-1"></i> Clusters
@endsection
@section('content')
<div class="container-fluid pt-3">
  <div class="card card-primary card-outline">
    <div class="card-body">
      <div class="my-3 text-center">
        <a class="btn btn-outline-primary" href="{{ route('add-cluster-form') }}"><i class="fas fa-plus mr-1"></i> Create cluster</a>
      </div>
      <hr />
      @if (count($clusters) === 0)
        {{ __('No clusters found.') }}
      @else
        <table class="table table-sm">
          <thead>
            <tr>
              <th>Name</th>
              <th>Notifications</th>
              <th>Servers (Alive / Total)</th>
              <th>Zones (Total / Excluded)</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            @foreach ($clusters as $cluster)
              <tr>
                <td>{{ $cluster->name }}</td>
                <td>
                  @if( $cluster->email_notifications )
                      On
                  @else
                      Off
                  @endif
                </td>
                <td>
                  <span style="color: #0B0;">{{ $cluster->getAvailableServers() }}</span> / {{ $cluster->getTotalServers() }}
                </td>
                <td>
                  {{ $cluster->getTotalZones() }} / {{ $cluster->getExcludedZones() }}
                </td>
                <td>
                  <div class="btn-group">
                    <a class="btn btn-default" href="{{ route('edit-cluster-form', ['id' => $cluster->id]) }}">Edit</a>
                    <a class="btn btn-danger" href="{{ route('delete-cluster-form', ['id' => $cluster->id] ) }}">Delete</a>
                  </div>
                </td>
              </tr>
            @endforeach
          </tbody>
        </table>
      @endif
    </div>
  </div>
</div>
<script>
  $(document).ready(function()
  {
    $('#menu-clusters').addClass('active');
  });
</script>
@endsection
