@extends('layouts.app')
@section('title')
  <i class="fas fa-user mr-1 mt-1"></i> Users
@endsection

@section('content')
<div class="modal" id="user_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><span id="user_name"></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="user_msg"></div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text">User name</span>
          </div>
          <input class="form-control" type="text" id="user_name_input" placeholder="User name">
          <input type="hidden" id="user_id">
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text">User email</span>
          </div>
          <input class="form-control" type="text" id="user_email_input" placeholder="User email">
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text">Password</span>
          </div>
          <input class="form-control" type="text" id="user_password_input" placeholder="User password (leave empty to not change)">
        </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-primary" id="btn_save"><i class="fas fa-save mr-1"></i> Save</button>
      </div>
    </div>
  </div>
</div>

<div class="modal" id="add_user_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Add user</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="add_user_msg"></div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text">User name</span>
          </div>
          <input class="form-control" type="text" id="add_user_name_input" placeholder="User name">
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text">User email</span>
          </div>
          <input class="form-control" type="text" id="add_user_email_input" placeholder="User email">
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text">Password</span>
          </div>
          <input class="form-control" type="text" id="add_user_password_input" placeholder="User password">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-primary" id="btn_add_user"><i class="fas fa-save mr-1"></i> Create</button>
      </div>
    </div>
  </div>
</div> <!-- Create user modal -->
<div class="modal" id="delete_user_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Delete user</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="delete_user_msg"></div>
        <input type="hidden" id="delete_user_id">
        <div class="alert alert-danger">You are about to delete <strong><span id="delete_user_name"></span></strong>. Continue?</div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-danger" id="btn_delete_user"><i class="fas fa-trash mr-1"></i> Delete</button>
      </div>
    </div>
  </div>
</div> <!-- Delete user modal -->
<div class="container-fluid pt-3">
    <div class="card card-primary card-outline">
      <div class="card-body">
        <div class="text-center">
          <button id="create_user_btn" class="btn btn-outline-secondary"><i class="fas fa-plus mr-1"></i> CREATE USER</button>
        </div>
        <hr />
        @if (count($users) == 0)
          <div class="alert alert-warning">No users found</div>
        @else
          <table class="table table-sm">
            <thead>
              <tr>
                <th>Name</th>
                <th>E-mail</th>
                <th><i class="fas fa-cog"></i></th>
              </tr>
            </thead>
            <tbody>
            @foreach ($users as $user)
                <tr>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td><div class="btn-group"><button class="btn btn-sm btn-secondary btn_edit" data-email="{{ $user->email }}" data-name="{{ $user->name }}" data-user_id="{{ $user->id }}"><i class="fas fa-edit mr-1"></i> Edit</button> <button class="btn btn-danger btn-sm btn_delete" data-name="{{ $user->name }}" data-user_id="{{ $user->id }}"><i class="fas fa-trash mr-1"></i> Delete</button></div></td>
                </tr>
            @endforeach
            </tbody>
          </table>
        @endif
      </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function ()
    {
      $('#menu-users').addClass('active');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $(document).on('click', '#create_user_btn', function ()
        {
            $('#add_user_msg').html('');
            $('#add_user_name_input').val('');
            $('#add_user_email_input').val('');
            $('#add_user_password_input').val('');
            $('#add_user_modal').modal('show');
        });

        $(document).on('click', '.btn_delete', function ()
        {
            var name = $(this).data('name');
            var id = $(this).data('user_id');

            $('#delete_user_id').val(id);
            $('#delete_user_name').html(name);
            $('#delete_user_msg').html('');
            $('#delete_user_modal').modal('show');
        });

        $(document).on('click', '#btn_delete_user', function ()
        {
            var id = $('#delete_user_id').val();
            $.ajax({
                type : 'POST',
                url : '/users/delete',
                data : {id:id},
                success : function(response) 
                {
                    
                    if (response.code == "ok")
                    {
                        $('#delete_user_msg').html('<div class="alert alert-success">' + response.message + '</div>');
                    }
                    else
                    {
                         $('#delete_user_msg').html('<div class="alert alert-danger">' + response.message + '</div>');
                    }
                }
            });
        });
        $('#btn_add_user').on('click', function () {
            var name = $('#add_user_name_input').val();
            var email = $('#add_user_email_input').val();
            var password = $('#add_user_password_input').val();
            if ( name == "" || email == ""  || password == "" )
            {
                alert('Fill in the fields');
                return;
            }
            $.ajax({
                type : 'POST',
                url : '/users/create',
                data : {name:name, email:email, password:password},
                success : function(response) 
                {
                    
                    if (response.code == "ok")
                    {
                        $('#add_user_msg').html('<div class="alert alert-success">' + response.message + '</div>');
                    }
                    else
                    {
                         $('#add_user_msg').html('<div class="alert alert-danger">' + response.message + '</div>');
                    }
                },
                error : function(xhr, status, err)
                {
                    var errors = $.parseJSON(xhr.responseText);
                    var msg = "";
                    $.each(errors, function (key, value)
                    {
                        if (key=="errors")
                        {
                            var error = value;
                            $.each(error, function (ekey, evalue)
                            {
                                msg += ekey + ": ";
                                $.each(evalue, function (error_key, error_msg)
                                {
                                    msg += error_msg + " ";
                                });
                            });
                        }
                    });
                    $('#add_user_msg').html('<div class="alert alert-danger">' + msg + '</div>');
                }
            });
        });

        $(document).on('click', '.btn_edit', function ()
        {
            var name = $(this).data('name');
            var id = $(this).data('user_id');
            var email = $(this).data('email');
            $('#user_name').html(name);
            $('#user_name_input').val(name);
            $('#user_email_input').val(email);
            $('#user_id').val(id);
            $('#user_password_input').val('');
            $('#user_msg').html('');
            $('#user_modal').modal('show');
        });
        $('#btn_save').on('click', function () {
            var new_name = $('#user_name_input').val();
            var new_email = $('#user_email_input').val();
            var new_password = $('#user_password_input').val();
            var id = $('#user_id').val();
            if ( new_name == "" || new_email == "" )
            {
                alert('Fill in the fields');
                return;
            }
            $.ajax({
                type : 'POST',
                url : '/users/save',
                data : {id:id, name:new_name, email:new_email, password:new_password},
                success : function(response) 
                {
                    
                    if (response.code == "ok")
                    {
                        $('#user_msg').html('<div class="alert alert-success">' + response.message + '</div>');
                    }
                    else
                    {
                         $('#user_msg').html('<div class="alert alert-danger">' + response.message + '</div>');
                    }
                },
                error : function(xhr, status, err)
                {
                    var errors = $.parseJSON(xhr.responseText);
                    var msg = "";
                    $.each(errors, function (key, value)
                    {
                        if (key=="errors")
                        {
                            var error = value;
                            $.each(error, function (ekey, evalue)
                            {
                                msg += ekey + ": ";
                                $.each(evalue, function (error_key, error_msg)
                                {
                                    msg += error_msg + " ";
                                });
                            });
                        }
                    });
                    $('#user_msg').html('<div class="alert alert-danger">' + msg + '</div>');
                }
            });
        });
    });
</script>
@endsection
