@extends('layouts.app')

@section('title')
  <i class="fas fa-server mr-1 mt-1"></i> Servers
@endsection

@section('content')
<div id="config_modal" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><span id="server_name"></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="text-center">
          <div class="btn-group mb-3">
            <button class="btn btn-default btn_conf" data-conf_id="zcloud_conf">zCloud config</button>
            <button class="btn btn-default btn_conf" data-conf_id="named_conf">Named config</button>
            <button class="btn btn-default btn_conf" data-conf_id="pdns_conf">PowerDNS config</button>
          </div>
        </div>
        <input type="hidden" id="conf_type">
        <div class="alert alert-info" id="alert_conf" role="alert">
        </div>
        <pre id="zcloud_conf_txt" style="background-color:black;color:white;padding:20px;border-radius:5px;"></pre>
        <pre id="named_conf_txt" style="background-color:black;color:white;padding:20px;border-radius:5px;"></pre>
        <pre id="pdns_conf_txt" style="background-color:black;color:white;padding:20px;border-radius:5px;"></pre>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<div class="container-fluid pt-3">
  <div class="card card-primary card-outline">
    <div class="card-body">
      <div class="text-center">
        <div class="my-3">
          <a href="{{ route('add-server') }}" class="btn btn-outline-primary"><i class="fas fa-plus mr-1"></i> Create server</a>
        </div>
        @if(count($clusters) > 0)
          <div class="my-3 col-sm-6 offset-sm-3">
            <div id="msg_cluster"></div>
            <div class="input-group">
              <span class="input-group-prepend">
                <button class="btn btn-secondary" id="btn_cluster_recheck">Force recheck cluster</button>
              </span>
              <select id="cluster_recheck" class="custom-select">
                <option value="all">{{ __('All clusters') }}</option>
                @foreach($clusters as $cluster)
                  <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
                @endforeach
              </select> 
            </div>
          </div>
        @endif
      </div>
      <hr />
      @if (count($servers) === 0)
        No servers found
      @else
        <div id="msg"></div>
        <table class="table table-sm">
          <thead>
            <tr>
              <th>Name</th>
              <th>Token</th>
              <th>Type</th>
              <th>IP</th>
              <th>Zones</th>
              <th>Cluster</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            @foreach ($servers as $server)
              <tr>
                <td>{{ $server->name }}</td>
                <td>{{ $server->token }}</td>
                <td>{{ $server->getType() }}</td>
                <td>{{ $server->IP }}</td>
                <td>{{ $server->zones_count }}</td>
                <td>{{ $server->getCluster() }}</td>
                <td>
                  <div class="btn-group">
                    <a href="{{ route('edit-server-form', ['id' => $server->id]) }}" class="btn btn-default btn-sm">Edit</a>
                    <a href="{{ route('delete-server', ['id' => $server->id]) }}" class="btn btn-danger btn-sm">Delete</a>
                    <button class="btn btn-info btn-sm btn_recheck" data-server_id="{{ $server->id }}">Force re-check</button>
                    <button class="btn btn-default btn-sm btn_config" data-server_type="{{ $server->getType() }}" data-server_name="{{ $server->name }}" data-server_id="{{ $server->id }}">Configuration</button>
                  </div>
                </td>
              </tr>
            @endforeach
          </tbody>
        </table>
      @endif
    </div> <!-- card body -->
  </div> <!-- card -->
</div>

<script type="text/javascript">
    $(document).ready(function(){
      $('#menu-servers').addClass('active'); 
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $("#btn_cluster_recheck").on("click", function (){
            var cluster = $("#cluster_recheck").val();
            $.ajax({
                type : 'POST',
                url : '/servers/recheck_cluster',
                data : {cluster:cluster},
                success : function(response) 
                {
                    if (response.code == "ok")
                    {
                        $('#msg_cluster').html('<div class="alert alert-success"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    else
                    {
                        $('#msg_cluster').html('<div class="alert alert-warning"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    $('.message .close')
                    .on('click', function() {
                        $(this)
                            .closest('.message')
                            .transition('fade');
                    });
                }
            })
        });
        $(".btn_recheck").on("click", function(){
            var server_id = $(this).data("server_id");
            $.ajax({
                type : 'POST',
                url : '/servers/recheck',
                data : {server_id:server_id},
                success : function(response) 
                {
                    if (response.code == "ok")
                    {
                        $('#msg').html('<div class="alert alert-success"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    else
                    {
                        $('#msg').html('<div class="alert alert-warning"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    $('.message .close')
                    .on('click', function() {
                        $(this)
                            .closest('.message')
                            .transition('fade');
                    });
                }
            })

        })
        $(document).on('click', '.btn_config', function() {
            var server_name = $(this).data('server_name');
            var server_id = $(this).data('server_id');
            $("#conf_type").val($(this).data("server_type"));
            $.ajax({
                type : 'POST',
                url : '{{ route("servers_show_configuration") }}',
                data : {server_id:server_id},
                success : function(response) 
                {
                  var zcloud_conf = response.zcloud;
                  $('#zcloud_conf_txt').html(zcloud_conf);
                  $('#named_conf_txt').html(response.named);
                  $('#pdns_conf_txt').html(response.pdns);
                }
            });

            $('#server_name').html(server_name);
            $('#config_modal')
                .modal('show');
            $('#zcloud_conf_txt').hide();
            $('#named_conf_txt').hide();
            $('#pdns_conf_txt').hide();
            $('#alert_conf').hide();

        });

        $('#config_modal').on('click', '.btn_conf', function()
        {
          var conf = $(this).data("conf_id");
          $('#alert_conf').show();

          if ( conf == "zcloud_conf" )
          {
            if ( $('#conf_type').val() == "Agent" )
              $('#alert_conf').html("Configuration file location: /etc/zcloudagent.conf");
            else
              $('#alert_conf').html("Configuration file location: /etc/zcloudnode.conf");

            $('#zcloud_conf_txt').show();
            $('#named_conf_txt').hide();
            $('#pdns_conf_txt').hide();
          }
          else if ( conf == "pdns_conf" ) 
          {
            $('#alert_conf').html("Configuration file location: /etc/pdns/pdns.conf");
            $('#zcloud_conf_txt').hide();
            $('#named_conf_txt').hide();
            $('#pdns_conf_txt').show();
          }
          else if ( conf == "named_conf" )
          {
            $('#alert_conf').html("Configuration file location: /etc/named.conf");
            $('#zcloud_conf_txt').hide();
            $('#named_conf_txt').show();
            $('#pdns_conf_txt').hide();
          }
        });
        
    });
</script>
@endsection
