@extends('layouts.app')

@section('title')
  <i class="fas fa-history mr-1 mt-1"></i> Server incidents
@endsection
@section('content')

<div class="container-fluid pt-3">
  <div class="card card-primary card-outline">
    <div class="card-body">
      @foreach($incidents as $server)
        <div class="card card-secondary">
          <div class="card-header">
            {{ $server->server_name }}
          </div>
          <div class="card-body">
            @if(count($server->data)>0)
              <table class="table table-sm table-striped">
                <thead>
                  <tr>
                    <th>{{ __('Duration') }}</th>
                    <th>{{ __('Start timestamp') }}</th>
                    <th>{{ __('End timestamp') }}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($server->data as $incident)
                    <tr>
                      <td class="negative">{{ $incident[0]['duration'] }}</td>
                      <td>{{ $incident[0]['start'] }}</td>
                      <td>{{ $incident[0]['stop'] }}</td>
                    </tr> 
                  @endforeach
                </tbody>
              </table>
            @else
              {{ __('No incidents found') }}
            @endif
          </div>
        </div>
      @endforeach
    </div>
  </div>
</div>

<script>
$(document).ready(function()
{
  $('#menu-logs').addClass('active');
  $('#menu-incident-logs').addClass('active');

});
</script>

@endsection
