@extends('layouts.app')

@section('title')
  <i class="fas fa-server mr-1 mt-1"></i> Servers
@endsection

@section('content')
<div class="container-fluid pt-3">
  <div class="card card-primary card-outline">
    <div class="card-body">
      <div class="text-center">
        <div class="my-3">
          <a href="{{ route('add-server') }}" class="btn btn-outline-primary"><i class="fas fa-plus mr-1"></i> Create server</a>
        </div>
        @if(count($clusters) > 0)
          <div class="my-3 col-sm-6 offset-sm-3">
            <div id="msg_cluster"></div>
            <div class="input-group">
              <span class="input-group-prepend">
                <button class="btn btn-secondary" id="btn_cluster_recheck">Force recheck cluster</button>
              </span>
              <select id="cluster_recheck" class="custom-select">
                <option value="all">{{ __('All clusters') }}</option>
                @foreach($clusters as $cluster)
                  <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
                @endforeach
              </select> 
            </div>
          </div>
        @endif
      </div>
      <hr />
      @if (count($servers) === 0)
        No servers found
      @else
        <div id="msg"></div>
        <table class="table table-sm">
          <thead>
            <tr>
              <th>Name</th>
              <th>Token</th>
              <th>Type</th>
              <th>IP</th>
              <th>Zones</th>
              <th>Cluster</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            @foreach ($servers as $server)
              <tr>
                <td>{{ $server->name }}</td>
                <td>{{ $server->token }}</td>
                <td>{{ $server->getType() }}</td>
                <td>{{ $server->IP }}</td>
                <td>{{ $server->zones_count }}</td>
                <td>{{ $server->getCluster() }}</td>
                <td>
                  <div class="btn-group">
                    <a href="{{ route('edit-server-form', ['id' => $server->id]) }}" class="btn btn-default btn-sm">Edit</a>
                    <a href="{{ route('delete-server', ['id' => $server->id]) }}" class="btn btn-danger btn-sm">Delete</a>
                    <button class="btn btn-info btn-sm btn_recheck" data-server_id="{{ $server->id }}">Force re-check</button>
                  </div>
                </td>
              </tr>
            @endforeach
          </tbody>
        </table>
      @endif
    </div> <!-- card body -->
  </div> <!-- card -->
</div>

<script type="text/javascript">
    $(document).ready(function(){
      $('#menu-servers').addClass('active'); 
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $("#btn_cluster_recheck").on("click", function (){
            var cluster = $("#cluster_recheck").val();
            $.ajax({
                type : 'POST',
                url : '/servers/recheck_cluster',
                data : {cluster:cluster},
                success : function(response) 
                {
                    if (response.code == "ok")
                    {
                        $('#msg_cluster').html('<div class="alert alert-success"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    else
                    {
                        $('#msg_cluster').html('<div class="alert alert-warning"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    $('.message .close')
                    .on('click', function() {
                        $(this)
                            .closest('.message')
                            .transition('fade');
                    });
                }
            })
        });
        $(".btn_recheck").on("click", function(){
            var server_id = $(this).data("server_id");
            $.ajax({
                type : 'POST',
                url : '/servers/recheck',
                data : {server_id:server_id},
                success : function(response) 
                {
                    if (response.code == "ok")
                    {
                        $('#msg').html('<div class="alert alert-success"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    else
                    {
                        $('#msg').html('<div class="alert alert-warning"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    $('.message .close')
                    .on('click', function() {
                        $(this)
                            .closest('.message')
                            .transition('fade');
                    });
                }
            })

        })
        
        });
</script>
@endsection
