<nav class="main-header navbar navbar-expand navbar-white navbar-light">
  <!-- Left navbar links -->
  <ul class="navbar-nav">
    <li class="nav-item">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
    </li>
  </ul>
  <span class="navbar-nav">
    @yield('title')
  </span>
</nav>
  <!-- /.navbar -->
   <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="{{ route('home') }}" class="brand-link">
      <img src="/images/logo.png"
           alt="zone Cloud logo"
           class="brand-image img-circle elevation-3"
           style="opacity: .8; background-color: white">
      <span class="brand-text font-weight-light">Controller</span>
    </a>
    @guest
    @else
			<div class="user-panel mt-3 pb-3 mb-3 d-flex text-white">
        <div class="info">
          <span href="#" class="d-block"><i class="fas fa-user"></i> {{ \Auth::user()->name }}</span>
          <span href="#" title="{{ \Carbon\Carbon::now()->tzName }}" class="d-block"><i class="fas fa-clock"></i> {{ \Carbon\Carbon::now() }}</span>
        </div>
      </div>

    @endif



    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          @guest
          <li class="nav-item">
            <a href="{{ route('login') }}" class="nav-link" id="menu-login">
              <i class="nav-icon fas fa-sign-in-alt"></i>
              <p>
                Login
              </p>
            </a>
          </li>
          @else
          <li class="nav-item">
            <a href="{{ route('home') }}" class="nav-link" id="menu-home">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('servers') }}" class="nav-link" id="menu-servers">
              <i class="nav-icon fas fa-server"></i>
              <p>
                Servers
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('clusters') }}" class="nav-link" id="menu-clusters">
              <i class="nav-icon fas fa-sitemap"></i>
              <p>
                Clusters
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('zones') }}" class="nav-link" id="menu-zones">
              <i class="nav-icon fas fa-globe"></i>
              <p>
                Zones
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('blacklist-reports') }}" class="nav-link" id="menu-blacklist-reports">
              <i class="nav-icon fas fa-list"></i>
              <p>
                Blacklist reports
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('graphs') }}" class="nav-link" id="menu-graphs">
              <i class="nav-icon fas fa-chart-area"></i>
              <p>
               Graphs
              </p>
            </a>
          </li>
					<li class="nav-item has-treeview">
						<a href="#" class="nav-link" id="menu-logs">
							<i class="nav-icon fas fa-history"></i>
							<p>
								Logs
								<i class="right fas fa-angle-left"></i>
							</p>
						</a>
						<ul class="nav nav-treeview">
							<li class="nav-item">
								<a href="{{ route('logs') }}" class="nav-link" id="menu-zones-logs">
									<i class="far fa-circle nav-icon"></i>
									<p>Zone Logs</p>
								</a>
							</li>
							<li class="nav-item">
								<a id="menu-user-logs" href="{{ route('userlogs') }}" class="nav-link">
									<i class="far fa-circle nav-icon"></i>
									<p>User action logs</p>
								</a>
							</li>
							<li class="nav-item">
								<a id="menu-incident-logs" href="{{ route('serverlogs') }}" class="nav-link">
									<i class="far fa-circle nav-icon"></i>
									<p>Server incidents</p>
								</a>
							</li>
						</ul>
					</li>
          <li class="nav-item">
            <a href="{{ route('settings') }}" class="nav-link" id="menu-settings">
              <i class="nav-icon fas fa-cog"></i>
              <p>
               Settings
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('app_api') }}" class="nav-link" id="menu-app-api">
              <i class="nav-icon fas fa-code"></i>
              <p>
               App API Access
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('dnstool') }}" class="nav-link" id="menu-dnstool">
              <i class="nav-icon fas fa-wrench"></i>
              <p>
                DNS Diagnosis
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('users') }}" class="nav-link" id="menu-users">
              <i class="nav-icon fas fa-user"></i>
              <p>
               Users
              </p>
            </a>
          </li>
         <li class="nav-item">
            <a href="{{ route('logout') }}" class="nav-link"
								onclick="event.preventDefault();
                document.getElementById('logout-form').submit();"
						>
              <i class="nav-icon fas fa-sign-out-alt"></i>
              <p>
               Logout
              </p>
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                @csrf
            </form>
          </li>

        @endif

        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside> 
