@extends('layouts.app')

@section('content')

<div class="container">
  <div class="content-header text-center">
     <h1>Reset password</h1>
  </div> 
  <div class="card card-primary card-outline">
    <div class="card-body">
      @if (session('status'))
        <div class="alert alert-success" role="alert">
          {{ session('status') }}
        </div>
      @endif
      <form method="POST" action="{{ route('password.email') }}">
        @csrf
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <div class="input-group-text">
              <i class="fas fa-envelope mr-1"></i> E-mail
            </div>
          </div>
          <input class="form-control @error('email') is-invalid @enderror" id="email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="E-mail">
        </div>
        <input type="submit" class="btn btn-primary" value="Send password reset link">
      </form>
    </div>
  </div>
</div>
@endsection
