
@extends('layouts.app')

@section('content')
<div class="container-fluid">
  <div class="content-header text-center">
    <h1><i class="fas fa-wrench"></i> DNS Diagnosis tool <i class="fas fa-question-circle" data-toggle="tooltip" title="This tool will help you spot abnormalities between your nodes regarding your zones."></i></h1>
  </div>
  <div class="card card-primary card-outline">
    <div class="card-body">
      <div class="row justify-content-md-center">
        <div class="col-md-auto">
          <div class="form-group">
            <select class="form-control" id="select_cluster">
              @foreach($clusters as $cluster)
                <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
              @endforeach
            </select>
          </div>
        </div>
        <div class="col-md-2">
          <button class="btn btn-primary" id="btnStart">Start check</button>
        </div>
      </div>
      <div class="row justify-content-md-center mb-3">
        <div id="msg" style="display:none;">
          <div class="d-flex justify-content-center"><div class="spinner-border centered" role="status"></div></div>
        </div>
      </div>
      <div class="row" style="display: none;" id="results_div">
        <div class="col">
          <div class="card card-warning shadow">
            <div class="card-header">
              Zones with potential problems
            </div>
            <div class="card-body">
              <table id="warning_table" class="table table-sm table-striped">
                <thead>
                  <tr>
                    <th>Zone</th>
                    <th>Status</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
        <div class="col">
          <div class="card card-success shadow">
            <div class="card-header">
              Valid zones
            </div>
            <div class="card-body">
              <table id="valid_table" class="table table-sm table-striped">
                <thead>
                  <tr>
                    <th>Zone</th>
                    <th>Status</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<link rel="stylesheet" type="text/css" href="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<script type="text/javascript" src="{{ asset('/css/adminlte-3.0.5/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
  $(document).ready(function()
  {
    $('[data-toggle="tooltip"]').tooltip();
    $('#menu-dnstool').addClass('active');
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });

    var warning_table = $('#warning_table').DataTable(
    {
      columns:
      [
        {
          data:  'zone',
        },
        {
          data:  'result',
          render: function(data, type, row, meta)
          {
            var output = "";
            for (x=0; x < data.length; x++)
            { 
              output+= '<span>' + data[x].name + ': <span class="badge badge-warning">' + data[x].answ.join() +  '</span></span><br/>';
            }

            return output;
          }
        },
      ]
    });
    var valid_table = $('#valid_table').DataTable(
    {
      columns:
      [
        {
          data:  'zone',
        },
        {
          data:  'result',
          render: function(data, type, row, meta)
          {
            var output = "";
            for (x=0; x < data.length; x++)
            { 
              output+= '<span>' + data[x].name + ': <span class="badge badge-success">' + data[x].answ.join() +  '</span></span><br/>';
            }

            return output;
          }
        },
      ]
    });
    $(document).on('click', '#btnStart', function()
    {
      var cluster_id = $('#select_cluster').val();
      if(cluster_id == null)
      {
        $(document).Toasts('create', {
          title: 'Cluster',
          class: 'bg-danger',
          autohide: true,
          delay: 5000,
          body: 'No cluster selected.'
        });
        return;
      }
      $('#results_div').show();
      valid_table.clear();
      warning_table.clear();
      $('#msg').show();
      perform_check(cluster_id);
    });

  function perform_check(cluster_id, after = 0)
  {
    
    $.ajax(
    {
      method: "POST",
      url: "{{ route('dnstool_check') }}",
      data: {cluster_id: cluster_id, after: after},
      success: function(response)
      {
        if(response.code != 0)
        {
          
          $(document).Toasts('create', {
            title: 'Error',
            class: 'bg-danger',
            autohide: true,
            delay: 5000,
            body: response.message
          });
          $('#msg').hide();
          return;
        }
        var result = response.result;
        for (i=0; i<result.length; i++)
        {
          var ns_array = result[i].result;
          var ns1 = ns_array[0];
          var is_equal = true;
          for(j=1; j<ns_array.length; j++)
          {
            
            if(!isEqual(ns1.answ,ns_array[j].answ))
            {
              is_equal = false;
            }
          }

          if(is_equal && ns1.answ !== 'N/A')
            valid_table.row.add(result[i]);
          else
            warning_table.row.add(result[i]);
        }
        valid_table.draw();
        warning_table.draw();

        if (response.more)
        {
          perform_check(cluster_id, response.after);
        }
        else
        {
          $('#msg').hide();
        }
      }
    });
  }

  });
  

  function isEqual(ar1, ar2)
  {
    return ar1.toString() === ar2.toString();
  }
</script>
@endsection
