@extends('layouts.app')

@section('content')
<div class="container-fluid">
  <div class="content-header text-center">
    <h1><i class="fas fa-tachometer-alt mr-1"></i> Dashboard</h1>
  </div>
  <div class="card">
    <div class="card-body">

      @if (count($servers_agents)+count($servers_nodes) === 0)
        {{ __('No servers found') }}
      @else
        @if (count($servers_agents) > 0)
          <div class="shadow card card-primary card-outline">
            <div class="card-header">
              <h3 class="card-title">Agents</h3>
            </div>
            <div class="card-body">
              <table class="table table-sm table-hover table-responsive-md">
                <thead>
                  <tr>
                    <th>Server name</th>
                    <th>Last seen</th>
                    <th>Zones</th>
                    <th>RBL Status</th>
                    <th>Cluster</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($servers_agents as $server)
                    <tr>
                      <td>{{ $server->name }} @if ($server->version) <span class="badge bg-primary">ver: {{ $server->version }}</span> @endif</td>
                      <td class="@if ($server->getBoolLastSeen()) {{ _('text-success') }} @else {{ __('text-danger') }} @endif">{{ $server->getDiffForHumans() }} {{ __('ago') }}</td>
                      <td>{{ $server->zones_count }}</td>
                      @if($server->isBlacklisted()->code == 0)
                        <td class="@if($server->isBlacklisted()->blacklisted) {{ _('text-danger') }} @else {{ _('text-success') }} @endif">@if($server->isBlacklisted()->blacklisted) <a href="{{ route('blacklist-reports') }}" class="btn btn-danger btn-sm">Listed</a> @else {{ _('Clean') }} @endif @if(!$server->isBlacklisted()->isRecent) (last check {{ $server->isBlacklisted()->timestamp }}) @endif</td>
                      @else
                        <td>N/A</td>
                      @endif
                      <td>{{ $server->getCluster() }}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div> 
          </div> <!-- Agent card -->
        @endif
        @if (count($servers_nodes) > 0)
          <div class="shadow card card-primary card-outline">
            <div class="card-header">
              <h3 class="card-title">Nodes</h3>
            </div>
            <div class="card-body">
              <table class="table table-sm table-hover table-responsive-md">
                <thead>
                  <tr>
                    <th>Server name</th>
                    <th>Last seen</th>
                    <th>Zones</th>
                    <th>RBL Status</th>
                    <th>Cluster</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($servers_nodes as $server)
                    <tr>
                      <td>{{ $server->name }} @if ($server->version) <span class="badge bg-primary">ver: {{ $server->version }}</span> @endif</td>
                      <td class="@if ($server->getBoolLastSeen()) {{ _('text-success') }} @else {{ __('text-danger') }} @endif">{{ $server->getDiffForHumans() }} {{ __('ago') }}</td>
                      <td>{{ $server->zones_count }}</td>
                      @if($server->isBlacklisted()->code == 0)
                        <td class="@if($server->isBlacklisted()->blacklisted) {{ _('text-danger') }} @else {{ _('text-success') }} @endif">@if($server->isBlacklisted()->blacklisted) <a href="{{ route('blacklist-reports') }}" class="btn btn-danger btn-sm">Listed</a> @else {{ _('Clean') }} @endif @if(!$server->isBlacklisted()->isRecent) (last check {{ $server->isBlacklisted()->timestamp }}) @endif</td>
                      @else
                        <td>N/A</td>
                      @endif
                      <td>{{ $server->getCluster() }}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div><!-- nodes cards -->
        @endif
      @endif
      <!-- logs/problems row -->
      <div class="row">
        <div class="col-md-6">
          <div class="shadow card card-secondary">
            <div class="card-header">
              Latest logs
            </div>
            <div class="card-body">
              @if (count($logs) === 0)
                {{ __('No logs found') }}
              @else
                <table class="table table-sm table-striped">
                  @foreach ($logs as $log)
                    <tr data-toggle="tooltip" data-placement="top" title="{{ $log->server_name }}">
                      <td>{{ $log->action }}</td>
                      <td>{{ $log->zone }}</td>
                      <td>{{ $log->timestamp }}</td>
                    </tr>
                  @endforeach
                </table>
              @endif
            </div>
          </div> <!-- logs card -->
        </div> <!-- col md -->
        <div class="col-md-6">
          <div class="shadow small-box @if($rbl_check->blacklisted) bg-danger @else bg-success @endif">
            <div class="inner">
              @if ($rbl_check->blacklisted)
                <h4>Listed in RBL</h4>
                <p>
                  Listed servers:
                  <ul>
                  @foreach($rbl_check->primary_servers as $srv)
                    <li>{{ $srv }}</li>
                  @endforeach
                  @foreach($rbl_check->additional_servers as $srv)
                    <li>{{ $srv }}</li>
                  @endforeach
                  </ul>
                </p>
              @else
                <h4>RBL Status: Clean</h4>
                <p>Your servers are not listed in any RBL.</p>
              @endif
            </div>
            <div class="icon">
              @if ($rbl_check->blacklisted)
                <i class="fas fa-list"></i>
              @else
                <i class="fas fa-check"></i>
              @endif
            </div>
            <a class="small-box-footer" href="{{ route('blacklist-reports') }}">
              See reports
              <i class="fas fa-arrow-circle-right"></i>
            </a>
          </div>
          <div class="shadow card @if(count($faulty_clusters) > 0) card-warning @else card-success @endif">
            <div class="card-header">
              Problems
            </div>
            <div class="card-body">
              @if ( count($faulty_clusters) > 0 )
                {{ _('Clusters with problems:') }}
                <ul>
                  @foreach ($faulty_clusters as $cluster)
                    <li>{{ $cluster->name }}</li>
                      <ul>
                      @foreach ($cluster->isFaulty()->reasons as $reason)
                        <li>{!! $reason !!}</li>
                      @endforeach
                      </ul>
                  @endforeach 
                </ul>
              @else
                No problems found 
              @endif
            </div>
          </div> <!-- problems card -->
        </div> <!-- col md-->
      </div> <!-- row -->
    </div> <!-- dashboard card body -->
  </div> <!-- dashboard card -->
</div> <!-- container -->
<script>
$(document).ready(function()
{
  $('[data-toggle="tooltip"]').tooltip();
  $('#menu-home').addClass('active');
});
</script>
@endsection
