@extends('layouts.app')

@section('content')
<div class="container-fluid">
  <div class="content-header">
    <h1>Edit cluster</h1>
  </div>
  <div class="card card-primary card-outline">
    <div class="card-body">
      @if(!$cluster)
        <div class="alert alert-warning">
          Cluster not found.
        </div>
      @else
        <form method="POST" action="">
          <div class="input-group mb-3">
            <div class="input-group-prepend">
              <span class="input-group-text">Cluster name</span>
            </div>
            <input class="form-control" type="text" name="name" value="{{ $cluster->name }}" placeholder="Cluster name" required autofocus>
          </div>
          <div class="form-group mb-3">
            <div class="form-check">
                <input class="form-check-input" type="checkbox" @if ($cluster->email_notifications) {{ __('checked') }} @endif name="notification">
                <label class="form-check-label">E-mail notifications</label>
            </div>
          </div>
          @csrf
          <input type="submit" class="btn btn-primary" value="Save">
        </form>
      @endif
    </div>
  </div>
</div>
<script>
  $(document).ready(function()
  {
    $('#menu-clusters').addClass('active');
  });
</script>
@endsection
 
