@extends('layouts.app')

@section('content')
<div class="container">
  <div class="content-header text-center">
    <h1><i class="fas fa-sign-in-alt mr-1"></i> Login</h1>
  </div>
  <div class="card">
    <div class="card-body">
      <form method="POST" action="{{ route('login') }}">
          @csrf
          <div class="input-group mb-3">
            <div class="input-group-prepend">
              <div class="input-group-text">
                <i class="fas fa-envelope mr-1"></i> E-mail
              </div>
            </div>
            <input class="form-control" id="email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
          </div>
           <div class="input-group mb-3">
            <div class="input-group-prepend">
              <div class="input-group-text">
                <i class="fas fa-lock mr-1"></i> Password
              </div>
            </div>
            <input class="form-control" id="password" type="password" name="password" required autocomplete="current-password">
          </div>
         
          <div class="input-group mb-3">
              <div class="form-check">
                  <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                  <label for="remember" class="form-check-label">
                      Remember Me
                  </label>
              </div>
          </div>

          <div class="input-group mb-3">
              <button type="submit" class="btn btn-primary">
                  <i class="fas fa-sign-in-alt mr-1"></i> Login
              </button>
          </div>
          <div class="input-group mb-3">
            @if (Route::has('password.request'))
              <a href="{{ route('password.request') }}">
                Forgot Your Password?
              </a>
            @endif
          </div>
          @error('email')
            <span class="alert alert-danger" role="alert">
              <strong>{{ $message }}</strong>
            </span>
          @enderror
          @error('password')
            <span class="alert alert-danger" role="alert">
              <strong>{{ $message }}</strong>
            </span>
          @enderror

      </form>
    </div>
  </div>
</div>
<script>
  $(document).ready(function()
  {
    $('#menu-login').addClass('active');
  });
</script>
@endsection
