@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="content-header">
      <h1>Add a server</h1>
    </div>
    <div class="card card-primary card-outline">
      <div class="card-body">
        @if (count($clusters) == 0)
          <div class="alert alert-warning">
            {{ __('No clusters found!') }}
            <a href="{{ route('add-cluster-form') }}" class="btn btn-primary">{{ __('CREATE A CLUSTER') }}</a>
          </div>
        @else
          @if ($errors->any())
            <div class="ui negative message">
              <ul>
              @foreach ($errors->all() as $error)
                <li>{{$error}}</li>
              @endforeach
              </ul>
            </div>
          @endif
          <form method="POST" action="">
            <div class="input-group mb-3">
              <div class="input-group-prepend">
                <span class="input-group-text">Server name</span>
              </div>
              <input class="form-control" type="text" name="name" placeholder="Server name" required autofocus>
            </div>
            <div class="input-group mb-3">
              <div class="input-group-prepend">
                <span class="input-group-text">Server token</span>
              </div>
              <input class="form-control" id="token" type="text" name="token" placeholder="Server token" required>
              <div class="input-group-append">
                  <button id="tokenGenerator" class="btn btn-secondary" type="button">GENERATE</button>
              </div>
            </div>
            <div class="input-group mb-3">
              <div class="input-group-prepend">
                <span class="input-group-text">IP</span>
              </div>
              <input class="form-control" type="text" name="IP" placeholder="IP" required autofocus>
            </div>
            <div class="input-group mb-3">
              <div class="form-check">
                <input class="form-check-input" checked="checked" type="radio" name="type" value="1">
                <label>Agent</label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="type" value="2">
                <label>Node</label>
              </div>
            </div>
            <div class="row">
              <div class="col-md-3">
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <label class="input-group-text">Cluster</label>
                  </div>
                  <select class="custom-select" name="cluster_id">
                    @foreach ($clusters as $cluster)
                      <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
                    @endforeach
                  </select>
                </div>
              </div>
            </div>
            @csrf
            <input type="submit" class="btn btn-primary" value="Save">
          </form>
        @endif
      </div>
    </div>
</div>
<script type="text/javascript">
$( document ).ready(function() {
  $('#menu-servers').addClass('active');

// set the length of the string
var stringLength = 32;

// list containing characters for the random string
var stringArray = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];

$("#tokenGenerator").click(function (){

    var rndString = "";

    // build a string with random characters
    for (var i = 1; i < stringLength; i++) { 
        var rndNum = Math.ceil(Math.random() * stringArray.length) - 1;
        rndString = rndString + stringArray[rndNum];
    };
    
    $("#token").val(rndString);

});

});
</script>
@endsection
 
