@extends('layouts.app')

@section('content')
<div class="container">
  <div class="content-header text-center">
     <h1>Reset password</h1>
  </div> 
  <div class="card card-primary card-outline">
    <div class="card-body">
      <form method="POST" action="{{ route('password.update') }}">
        @csrf
        <input type="hidden" name="token" value="{{ $token }}">
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <div class="input-group-text">
              <i class="fas fa-envelope mr-1"></i> E-mail
            </div>
          </div>
          <input class="form-control @error('email') is-invalid @enderror" placeholder="E-mail" id="email" type="email" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <div class="input-group-text">
              <i class="fas fa-lock mr-1"></i> Password
            </div>
          </div>
          <input class="form-control @error('password') is-invalid @enderror" placeholder="New password" id="password" type="password" name="password" required autocomplete="new-password">
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <div class="input-group-text">
              <i class="fas fa-lock mr-1"></i> Confirm password
            </div>
          </div>
          <input class="form-control" placeholder="Confirm new password" id="password-confirm" type="password" name="password_confirmation" required autocomplete="new-password">
        </div>
        <input type="submit" class="btn btn-primary" value="Reset Password">
      </form>
    </div>
  </div>
</div>
@endsection
