@extends('layouts.app')

@section('content')
<div id="data_modal" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Values</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="modal_data"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<div class="container-fluid">
    <div class="content-header text-center">
      <h1><i class="fas fa-history mr-1"></i> User logs</h1>
    </div>
    <div class="card card-primary card-outline">
      <div class="card-body">
        <div id="msg"></div>
        @if ($userlogs==null)
            {{ __('No logs found') }}
        @else
            <table id="table_logs" class="table table-sm table-striped">
                <thead>
                    <tr>
                        <th>{{ __('User name') }}</th>
                        <th>{{ __('Action') }}</th>
                        <th>{{ __('IP') }}</th>
                        <th>{{ __('Time') }}</th>
                        <th>{{ __('Data') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($userlogs as $log)
                    <tr>
                        <td>{{ $log->username }} </td>
                        <td>{{ $log->action }}</td>
                        <td>{{ $log->ip }}</td>
                        <td data-order="{{ $log->timestamp }}">{{ \Carbon\Carbon::parse($log->timestamp)->format('j F Y H:i') }}</td>
                        <td><button data-values="{{ $log->value }}" class="btn btn-xs btn-outline-primary data_btn"><i class="fas fa-eye mr-1 "></i> Data</button></td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        @endif
      </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<script type="text/javascript" src="{{ asset('/css/adminlte-3.0.5/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
$(document).ready(function() {
  $('#menu-logs').addClass('active');
  $('#menu-user-logs').addClass('active');

    $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    $(document).on('click', '.data_btn', function() {
        var data = $(this).data('values');
        var output = '<table class="table table-sm table-hover"><thead><tr><th>Key</th><th>Value</th></thead><tbody>';
        Object.keys(data).forEach(function(key) {
					if(typeof data[key] === 'object')
            output = output + '<tr><td>' + key + '</td><td>' + JSON.stringify(data[key]) + '</td></tr>';
					else
            output = output + '<tr><td>' + key + '</td><td>' + data[key] + '</td></tr>';
        });
        output = output + '</tbody></table>';
        

        $('#modal_data').html(output);
        $('#data_modal').modal('show');
    });
    $('#table_logs').DataTable(
        {
            "pageLength": 50,
            "order": [[3, "desc"]]
        }
    );
} );
</script>
@endsection
