@extends('layouts.app')

@section('content')
<div class="container-fluid">
  <div class="content-header text-center">
    <h1><i class="fas fa-chart-area mr-1"></i> Graphs</h1>
  </div>
  <div class="card">
    <div class="card-body">
      <div class="card card-primary">
        <div class="card-body">
          <canvas id="insert_delete_chart" width="400" height="400"></canvas>
         </div>
      </div>
      <div class="card card-primary">
        <div class="card-body">
          <canvas id="zones_chart" width="400" height="400"></canvas>
         </div>
      </div>
    </div>
  </div>
</div>
          
<link rel="stylesheet" href="{{ asset('css/adminlte-3.0.5/plugins/chart.js/Chart.min.css') }}"/>
<script src="{{ asset('css/adminlte-3.0.5/plugins/chart.js/Chart.min.js') }}"></script>

<script>
    var ctx = document.getElementById('insert_delete_chart').getContext('2d');
var myChart = new Chart(ctx, {
    type: 'line',
    data: {
		labels: [
			@foreach ($logs as $log)
			'{{ $log->year }} {{ $log->monthname }}',
			@endforeach
		],
        datasets: [{
            label: '# of Inserts',
			data: [
				@foreach ($logs as $log)
				{{ $log->count_insert }},
				@endforeach
			],
            borderColor: 'rgb(0, 159, 64, 1)',
			fill: false,
			lineTension: 0
        },{
            label: '# of Deletes',
			data: [
				@foreach ($logs as $log)
				{{ $log->count_delete }},
				@endforeach
			],
            borderColor: 'rgb(159, 0, 64)',
			fill: false,
			lineTension: 0
        }]
    },
	options: {
		tooltips: {
			mode: 'index',
			intersect: false
		},
        title: {
            display: true,
            text: 'Monthly deletes/inserts',
        },
		responsive: true,
		maintainAspectRatio: false,
	}
});
var zonesChart = document.getElementById('zones_chart').getContext('2d');
var myChart = new Chart(zonesChart, {
    type: 'horizontalBar',
    data: {
		labels: [
			@foreach ($servers as $server)
			'{{ $server->name }}',
			@endforeach
		],
        datasets: [{
            label: 'Zones count',
			data: [
				@foreach ($servers as $server)
				{{ $server->zones_count }},
				@endforeach
			],
			backgroundColor: 'rgba(0, 150, 64, 0.6)',
			fill: true,
        }],
	},
	options: {
		tooltips: {
			mode: 'index',
			intersect: false
		},
        title: {
            display: true,
            text: 'Zones per server',
        },
		responsive: true,
		maintainAspectRatio: false,
	}
});

  $(document).ready(function()
  {
    $('#menu-graphs').addClass('active');
  });
</script>
@endsection
