@extends('layouts.app')

@section('content')
<div id="rbl_modal" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Listed in</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="description" id="rbl_result">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div class="container-fluid">
  <div class="content-header text-center">
    <h1><i class="fas fa-list mr-1"></i> Blacklist reports</h1>
  </div>
  <div class="card card-primary card-outline">
    <div class="card-body">
      @foreach($reports as $report)
        <div class="card">
          <div class="card-header">
            {{ $report->server->name }}
          </div>
          <div class="card-body">
            <table class="table table-sm report_table">
              <thead>
                <tr>
                  <th>Status</th>
                  <th>Timestamp</th>
                </tr>
              </thead>
              <tbody>
                @foreach($report->blacklist_logs as $log)
                  <tr>
                    <td class="@if($log->blacklisted) negative @else positive @endif">@if($log->blacklisted) <button class="btn btn-danger btn-sm btnRbl" data-rbl="{{ $log->bls_result }}">Listed</button> in {{ $log->rblCount() }} RBLs out of {{ $rbls_count }} @else <span class="text-success">Clean</span> @endif </td>
                    <td>{{ $log->check_timestamp }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      @endforeach
    </div>
  </div>
  @foreach($additional_reports as $name => $report)
    <div class="card">
      <div class="card-header">
        {{ $name }}
      </div>
      <div class="card-body">
        <table class="table table-sm report_table">
            <thead>
              <tr>
                <th>Status</th>
                <th>Timestamp</th>
              </tr>
            </thead>
            <tbody>
              @foreach($report as $log)
                <tr>
                  <td class="@if($log->blacklisted) negative @else positive @endif">@if($log->blacklisted) <button class="btn btn-danger btn-sm btnRbl" data-rbl="{{ $log->bls_result }}">Listed</button> in {{ $log->rblCount() }} RBLs out of {{ $rbls_count }} @else <span class="text-success">Clean</span> @endif </td>
                  <td>{{ $log->check_timestamp }}</td>
                </tr>
              @endforeach
            </tbody>
        </table>
      </div>
    </div>
  @endforeach
</div>

<link rel="stylesheet" type="text/css" href="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<script type="text/javascript" src="{{ asset('/css/adminlte-3.0.5/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
  var tables = $('.report_table').DataTable({
    "pageLength": 10,
    "order": [[ 1, "desc"]]  
  });

  $(document).on('click', '.btnRbl', function()
  {
    var rbls = $(this).data('rbl');
    var output = "<ul>";
    for(var i = 0; i < rbls.length; i++)
    {
      output = output + "<li>" + rbls[i] + "</li>";
    }
    output = output + "</ul>";
    $('#rbl_result').html(output);
    $('#rbl_modal').modal('show');
  });
  $(document).ready(function()
  {
    $('#menu-blacklist-reports').addClass('active');
  });
</script>

@endsection
