@extends('layouts.app')

@section('content')
<!-- Exclude Modal content  -->
<div class="modal" id="modal_exclude" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Excluding <span class="modal_zone"></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        Exclude <strong><span class="modal_zone"></span></strong> from <strong><span class="modal_server"></span></strong>?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-warning" id="btnModalExclude">Exclude</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<!-- /Modal content   -->
<!-- Remove Exclude Modal content -->
<div class="modal" id="modal_remove_exclude" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Removing exclude of <span class="modal_remove_zone"></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        Remove exclude of <strong><span class="modal_remove_zone"></span></strong> from <strong><span class="modal_remove_server"></span></strong>?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="btnModalRemoveExclude">Remove exclude</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<!-- /Modal content -->
<div class="container-fluid">
  <div class="content-header text-center">
    <h1><i class="fas fa-globe mr-1"></i> Zones</h1>
  </div>
  <div class="card card-primary card-outline">
    <div class="card-body">
      <div class="row">
        <div class="col-md-6">
          <div class="shadow card card-secondary">
            <div class="card-header">
              All zones (<i data-toggle="tooltip" title="If the number of zones is big and loading is slow, you can disable zones complete load in 'Settings'. A search box will appear instead." class="fas fa-info-circle"></i>)
            </div>
            <div class="card-body">
              @if ($zones === 0)
                {{ __('No zones found.') }}
              @else
                <div id="msg" class="mb-3">
                @if( !$disable_zones_complete_load )
                    <div class="d-flex justify-content-center"><div class="spinner-border centered" role="status"></div></div>
				@endif
                </div>
                @if( $disable_zones_complete_load )
				<div class="input-group mb-3">
				  <input type="text" class="form-control" id="search_zones" placeholder="Search zones by name">
				  <div class="input-group-append">
					<button class="btn btn-outline-secondary" id="btn_search_zones" type="button"><i class="fas fa-search"></i> Search</button>
				  </div>
				</div>
                <hr>
                @else
                @endif
                <table id="table_zones" class="table table-sm table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Server</th>
                            <th>Insert date</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
              @endif
            </div>
          </div>
        </div>
        <div class="col-md-6">
          <div class="shadow card card-warning">
            <div class="card-header">
              Excluded zones
                <span class="float-right"><button id="btn_reload_excluded" class="btn btn-xs btn-default"><i class="fas fa-sync"></i></button></span>
            </div>
            <div class="card-body">
                <div id="msg_remove">
                    <div class="d-flex justify-content-center"><div class="spinner-border centered" role="status"></div></div>
                </div>
                <table id="table_excludes" class="table table-sm table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Server</th>
                            <th></th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          <div class="shadow card card-danger">
            <div class="card-header">
              Duplicate zones
                <span class="float-right"><button id="btn_reload_duplicates" class="btn btn-xs btn-default"><i class="fas fa-sync"></i></button></span>
            </div>
            <div class="card-body">
                <div id="msg_dup">
                    <div class="d-flex justify-content-center"><div class="spinner-border centered" role="status"></div></div>
                </div>
                <small>*NE/TD = <strong>N</strong>ot <strong>E</strong>xcluded server count / <strong>T</strong>otal <strong>D</strong>uplicate server count.</small>
                <hr />
                <table id="table_duplicates" class="table table-sm table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Servers</th>
                            <th>NE/TD*</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div> 
</div>

<link rel="stylesheet" type="text/css" href="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<script type="text/javascript" src="{{ asset('/css/adminlte-3.0.5/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('css/adminlte-3.0.5/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>

<script type="text/javascript">
  $(document).ready(function () {
      $('#menu-zones').addClass('active');
        var zones_table = $('#table_zones').DataTable({
            "pageLength": 100,
            "oLanguage": {
                "sSearch": "Filter: "
            },
            columns:
            [
                {data: 'zone'},
                {data: 'server_name'},
                {data: 'insert_date'},
                {
                    data: 'server_name',
                    render: function(data, type, row, meta)
                    {
                        return '<button class="btn btn-sm btn-warning btn_exclude" data-server_name="'+ data +'" data-zone="'+ row.zone +'" data-server="'+ row.server_id +'">Exclude</button>';
                    }
                },

            ]
        });
        var excludes_table = $('#table_excludes').DataTable(
        {
            "pageLength": 10,
            columns:
            [
                {data: 'zone'},
                {data: 'server_name'},
                {
                    data: 'server_name',
                    render: function(data, type, row, meta)
                    {
                        return '<button class="btn btn-sm btn-secondary btn_remove_exclude" data-server_name="'+ data +'" data-zone="'+ row.zone +'" data-server="'+ row.server_id +'">Remove exclusion</button>';
                    }
                },

            ]

        });
        var duplicates_table = $('#table_duplicates').DataTable(
        {
            "pageLength": 10,
            columns:
            [
                {data: 'zone'},
                {
                    data: 'duplicate_servers',
                    render: function(data, type, row, meta)
                    {
                        var ret = '<div class="btn-group">';
                        $.each(data, function(i, item)
                        {
                          if(row.excluded_in == 0)
                          {
                              ret += '<button class="btn btn-sm btn-warning btn_exclude" data-server_name="'+ item.name +'" data-zone="'+ row.zone +'" data-server="'+ item.id +'">'+ item.name +'</button>';
                          }
                          else
                          {
                            
                            var server_id = item.id;
                            var excluded = false;
                            $.each(row.excluded_in, function(j, excl)
                            {
                              if(excl.server_id == server_id)
                              {
                                excluded = true;
                              }
                            });
                            if(excluded)
                              ret += '<button class="btn btn-sm btn-warning disabled" data-toggle="tooltip" title="already excluded">'+ item.name +'</button>';
                            else
                              ret += '<button class="btn btn-sm btn-warning btn_exclude" data-server_name="'+ item.name +'" data-zone="'+ row.zone +'" data-server="'+ item.id +'">'+ item.name +'</button>';

                          }
                        });
                        ret += '</div>';
                        return ret;
                    }
                },
                {
                  data: 'not_excluded_server_count',
                  render: function(data, type, row, meta)
                  {
                    var ret = data + "/" + row.count;
                    return ret;
                  }
                },
            ]

        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        @if ($disable_zones_complete_load)
			$("#btn_search_zones").on("click", function()
			{
				$("#msg").html('<div class="d-flex justify-content-center"><div class="spinner-border centered" role="status"></div></div>');
				var query = $("#search_zones").val();
				$.ajax(
				{
					type: "POST",
					url: "/zones/search",
					data: {query:query},
					success: function(response)
					{
						zones_table.clear();
						zones_table.rows.add(response).draw();

						$("#msg").html('');
					}
				});
			});	

        @else
        function getMoreZones(after_id)
        {
            $.ajax(
            {
                type: "POST",
                url: "/zones/all",
                data: {id:after_id},
                success: function(response)
                {
                    zones_table.rows.add(response.zones).draw();
                    if(response.more)
                    {
                        getMoreZones(response.after);
                    }
                    else
                    {
                        $("#msg").html('');
                    }
                }
            });
        };

        $.ajax(
        {
            type: "GET",
            url: "/zones/all",
            success: function(response)
            {

                zones_table.clear();
                zones_table.rows.add(response.zones).draw();
                if(response.more)
                {
                    getMoreZones(response.after);
                }
                else
                {
                    $("#msg").html('');
                }
            }
        });
        @endif
        function load_excluded()
        {
          $.ajax(
          {
              type: "GET",
              url: "/zones/excluded",
              success: function(response)
              {
                  excludes_table.clear();
                  excludes_table.rows.add(response).draw();
                  $("#msg_remove").html('');
              }
          });
        }

        function load_duplicates()
        {
          $.ajax(
          {
              type: "GET",
              url: "/zones/duplicates",
              success: function(response)
              {
                  duplicates_table.clear();
                  duplicates_table.rows.add(response).draw();
                  
                  $("#msg_dup").html('');
              }
          });
        }

        load_excluded();
        load_duplicates();

        $(document).on('click', '#btn_reload_duplicates', function()
        {
          load_duplicates();
        });

        $(document).on('click', '#btn_reload_excluded', function()
        {
          load_excluded();
        });

        $(document).on('click', '.btn_exclude',  function () {
            var zone = $(this).data('zone');
            var server = $(this).data('server');
            var server_name = $(this).data('server_name')
            $('#btnModalExclude').data('zone',zone);
            $('#btnModalExclude').data('server',server);

            $('.modal_zone').text(zone);
            $('.modal_server').text(server_name);
            $('#modal_exclude').modal('show');
             
        });
        $(document).on('click', '#btnModalExclude', function()
            {
              var zone = $(this).data('zone');
              var server = $(this).data('server');
              $('#modal_exclude').modal('hide');
              $.ajax({
                type : 'POST',
                url : '/zones/exclude',
                data : {zone:zone, server:server},
                success : function(response)
                {
                  if (response.code == "ok")
                  {
										$(document).Toasts('create', {
										title: 'Excluding ' + zone,
										class: 'bg-success',
											autohide: true,
											delay: 2000,
											body: response.message
										});
                  }
                  else
                  {
										$(document).Toasts('create', {
											title: 'Excluding ' + zone,
											class: 'bg-warning',
											autohide: true,
											delay: 2000,
											body: response.message
										});
                  }
                }
              })
            });
        $(document).on('click', '.btn_remove_exclude', function ()
        {
            var zone = $(this).data('zone');
            var server = $(this).data('server');
            var server_name = $(this).data('server_name')
            $('#btnModalRemoveExclude').data('zone',zone);
            $('#btnModalRemoveExclude').data('server',server);
            $('.modal_remove_zone').text(zone);
            $('.modal_remove_server').text(server_name);
            $('#modal_remove_exclude').modal('show');

        });
        $(document).on('click', '#btnModalRemoveExclude', function()
        {
          var zone = $(this).data('zone');
          var server = $(this).data('server');

          $('#modal_remove_exclude').modal('hide');
          $.ajax({
              type : 'POST',
              url : '/zones/exclude/remove',
              data : {zone:zone, server:server},
              success : function(response)
              {
                  if (response.code == "ok")
                  {
										$(document).Toasts('create', {
										title: 'Removing exclude of ' + zone,
										class: 'bg-success',
											autohide: true,
											delay: 2000,
											body: response.message
										});
                  }
                  else
                  {
										if (response.code == "ok")
										{
											$(document).Toasts('create', {
											title: 'Removing exclude of ' + zone,
											class: 'bg-warning',
												autohide: true,
												delay: 2000,
												body: response.message
											});
										}
									}
              }
          });
        });
    });
</script>
@endsection
