@extends('layouts.app')

@section('content')
<div class="container-fluid">
  <div class="content-header text-center">
    <h1><i class="fas fa-cog mr-1"></i> Settings</h1>
  </div>
  <div class="card card-primary card-outline">
    <div class="card-body">
      @if ($errors->any())
        <div class="alert alert-danger">
          <ul>
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
          </ul>
        </div>
      @endif
      @if (Request()->message)
        <div class="alert alert-info">
          {{ Request()->message }}
        </div>
      @endif
      <form method="POST" action="">
        <div class="shadow card card-secondary">
          <div class="card-header">
            General settings
          </div>
          <div class="card-body">
            <div class="row">
              <div class="col-md-4">
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Last seen threshold in minutes (<i data-toggle="tooltip" title="Start sending notifications after X minutes of a server going offline." class="fas fa-question-circle"></i>)</span>
                  </div>
                  <input class="form-cntrol" type="number" name="last_seen" value="{{ $last_seen->getValue() }}" placeholder="Last seen limit" required autofocus>
                </div>
              </div>
              <div class="col-md-2">
                <div class="input-group mb-3">
                    <div class="input-group-text">
                      <input class="form-check-input ml-0"  type="checkbox" id="email_notifications" name="email_notifications" @if ($email_notifications->getValue()) {{ __('checked') }} @endif>
                      <label class="form-check-label ml-3" for="email_notifications">Email notifications (<i data-toggle="tooltip" title="Enable/Disable email notifications." class="fas fa-question-circle"></i>)</label>
                    </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Notifications recipient</span>
                  </div>
                  <input class="form-control" type="text" name="notifications_recipient" placeholder="e.g. alerts@mydomain.com" value="{{ $notifications_recipient->getValue() }}">
                </div>
              </div>
              <div class="col-md-4">
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Slack URL (<i data-toggle="tooltip" title="Slack URL to send notifications. Leave empty if you don't want slack notifications." class="fas fa-question-circle"></i>)</span>
                  </div>
                  <input class="form-control" type="text" name="slack_url" placeholder="https://hooks.slack.com/services/TXXXX/BYYYY/ZZZZ" value="{{ $slack_url ? ($slack_url->value_text ? $slack_url->value_text : ''): '' }}">
                </div>
              </div>
              <div class="col-md-2">
                <div class="input-group mb-3">
                    <div class="input-group-text">
		      <input class="form-check-input ml-0"  type="checkbox" id="disable_zones_complete_load" name="disable_zones_complete_load" {{ $disable_zones_complete_load ? ($disable_zones_complete_load->value_bool ? 'checked': ''): '' }}>
                      <label class="form-check-label ml-3" for="disable_zones_complete_load">Disable zones complete load (<i data-toggle="tooltip" title="Use this if the number of zones is very big and loading is slow. This will let you search for a zone instantly on the zones page." class="fas fa-question-circle"></i>)</label>
                    </div>
                </div>
              </div>

            </div>
          </div>
        </div>
        <div class="shadow card card-secondary">
          <div class="card-header">
            RBL Settings
          </div>
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Blacklists (<i data-toggle="tooltip" title="Comma separated RBLs to use for reputation checks." class="fas fa-question-circle"></i>)</span>
                  </div>
                  <textarea rows="5" class="form-control" name="blacklists" placeholder="e.g.: cbl.abuseat.org,zen.spamhaus.org">@if ($blacklists){{ $blacklists->value_text }}@endif</textarea>
                </div>
              </div>

              <div class="col-md-6">
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Additional servers (<i data-toggle="tooltip" title="Comma separated list of <SERVER_NAME>:<IP> to include in RBL reputation checks." class="fas fa-question-circle"></i>)</span>
                  </div>
                  <textarea rows="5" class="form-control" name="additional_servers" placeholder="<Server name>:<IP> list. e.g.: server1:123.123.123.123,server2:213.213.213.213">@if ($additional_servers){{ $additional_servers->value_text }}@endif</textarea>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="shadow card card-secondary">
          <div class="card-header">
            Updates <span class="badge badge-primary" id="current_version"></span>
          </div>
          <div class="card-body">
            <div class="row">
              <button class="btn btn-default" id="update_btn" type="button">Check for updates</button>
            </div>
            <div class="row">
              <div id="update_msg"></div>
            </div>
          </div>
        </div>
        <div class="shadow card card-secondary">
          <div class="card-header">
            License Status
          </div>
          <div class="card-body">
            @if ($license_data === false)
                {{ __('Can\'t get license data') }} 
            @else
            <table class="table table-sm">
                <tbody>
                    <tr>
                        <td>Status</td>
                        <td>{{ $license_data->status }}</td>
                    </tr>
                    <tr>
                        <td>Registered to</td>
                        <td>{{ $license_data->registeredname }}</td>
                    </tr>
                     <tr>
                        <td>Expiry date</td>
                        <td>{{ $license_data->nextduedate }}</td>
                    </tr>
                </tbody>
            </table> 
            @endif
          </div>
        </div>
        @csrf
        <button type="submit" class="btn btn-primary"><i class="fas fa-save mr-1"></i> Save</button>
      </form>
    </div>
  </div>
</div>
<script>
    $(document).ready(function ()
    {
      $('[data-toggle="tooltip"]').tooltip();

      $('#menu-settings').addClass('active');
        $.ajax({
            type: 'GET',
            url: '/updater.currentVersion',
            success: function(response)
            {
                $('#current_version').html('current version: ' + response);
            }
        });
        $(document).on('click', '#update_btn', function()
        {
            $.ajax({
                type: 'GET',
                url: '/updater.check',
                async: false,
                success: function(response)
                {
                    if(response != '')
                    {
                        $('#update_msg').html('<div class="alert alert-info my-3">Update available: ' + response + '. <a href="/updater.update" class="btn btn-secondary btn-sm">Click here</a> to start upgrade.</div>');
                    }
                    else
                    {
                        $('#update_msg').html('<div class="alert alert-success my-3">Controller is already on latest version.</div>');

                    }
                }
        })
    });
    });
</script>
@endsection

 
