@extends('layouts.app')

@section('content')
<div class="container-fluid">
  @if ($server->isEmpty())
    {{ __('Server not found') }}
  @else
    <div class="content-header">
      <h1>{{ $server[0]->name }}</h1>
    </div>
    <div class="card card-primary card-outline">
      <div class="card-body">
        <form method="POST" action="">
          <div class="input-group mb-3">
            <div class="input-group-prepend">
              <span class="input-group-text">Server name</span>
            </div>
            <input class="form-control" type="text" name="name" placeholder="Server name" value="{{ $server[0]->name }}" required autofocus>
          </div>
          <div class="input-group mb-3">
            <div class="input-group-prepend">
              <span class="input-group-text">Server token</span>
            </div>
            <input class="form-control" id="token" type="text" name="token" placeholder="Server token" value="{{ $server[0]->token }}" required>
            <div class="input-group-append">
              <button id="tokenGenerator" class="btn btn-secondary" type="button">GENERATE</button>
            </div>
          </div>
          <div class="input-group mb-3">
            <div class="input-group-prepend">
              <span class="input-group-text">IP</span>
            </div>
            <input class="form-control" type="text" name="IP" placeholder="IP" value="{{ $server[0]->IP }}" required autofocus>
          </div>
          <div class="col-md-3">
            <div class="input-group mb-3">
              <div class="form-check">
                <input class="form-check-input" @if ($server[0]->type === 1) checked @endif type="radio" name="type" value="1">
                <label>Agent</label>
              </div>
              <div class="form-check">
                <input class="form-check-input" @if ($server[0]->type === 2) checked @endif type="radio" name="type" value="2">
                <label>Node</label>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-3">
              <div class="input-group mb-3">
                <div class="input-group-prepend">
                  <label class="input-group-text">Cluster</label>
                </div>
                <select class="custom-select" name="cluster_id">
                  @foreach ($clusters as $cluster)
                    <option value="{{ $cluster->id }}" @if ( $server[0]->cluster_id == $cluster->id ) selected @endif>{{ $cluster->name }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>
          @csrf
          <input type="submit" class="btn btn-primary" value="Save">
        </form>
      </div>
    </div>
  @endif
</div>

<script type="text/javascript">
$( document ).ready(function() {
  $('#menu-servers').addClass('active');

// set the length of the string
var stringLength = 32;

// list containing characters for the random string
var stringArray = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];

$("#tokenGenerator").click(function (){

    var rndString = "";

    // build a string with random characters
    for (var i = 1; i < stringLength; i++) { 
        var rndNum = Math.ceil(Math.random() * stringArray.length) - 1;
        rndString = rndString + stringArray[rndNum];
    };
    
    $("#token").val(rndString);

});

});
</script>
@endsection
 
