@extends('layouts.app')

@section('content')
<!-- Exclude Modal content -->
<div class="ui basic modal exclude">
    <div class="ui icon header">
        <i class="exclamation mark icon"></i>
        Excluding <span class="modal_zone"></span>
    </div>
    <div class="content">
        Exclude <span class="modal_zone"></span> at <span class="modal_server"></span>?
    </div>
    <div class="actions">
        <div class="ui red basic cancel inverted button">
            <i class="close icon"></i>
            No
        </div>
        <div class="ui green ok inverted button">
            <i class="exclamation mark icon"></i>
            Yes
        </div>
    </div>

</div>
<!-- /Modal content -->
<!-- Remove Exclude Modal content -->
<div class="ui basic modal remove_exclude">
    <div class="ui icon header">
        <i class="trash mark icon"></i>
        Removing exclusion of <span class="modal_remove_zone"></span>
    </div>
    <div class="content">
        Remove exclusion of <span class="modal_remove_zone"></span> at <span class="modal_remove_server"></span>?
    </div>
    <div class="actions">
        <div class="ui red basic cancel inverted button">
            <i class="close icon"></i>
            No
        </div>
        <div class="ui green ok inverted button">
            <i class="exclamation mark icon"></i>
            Yes
        </div>
    </div>

</div>
<!-- /Modal content -->
<div class="ui stackable fluid container">
    <div class="ui stackable grid">
        <div class="eight wide column">
            <div class="ui top attached header">
                <i class="globe icon"></i> Zones
            </div>
            <div class="ui teal attached center aligned segment">
                @if ($zones === 0)
                    {{ __('No zones found.') }}
                @else
                    <div id="msg">

                    </div>
                    <table id="table_zones" class="ui very compact table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Server</th>
                                <th>Insert date</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
        <div class="eight wide column">
            <div class="ui top attached header">
                <i class="exclamation mark icon"></i> Excluded zones
            </div>
            <div class="ui teal attached center aligned segment">
                @if ($excluded_zones === 0)
                    {{ __('No zones found.') }}
                @else
                    <div id="msg_remove">

                    </div>
                    <table id="table_excludes" class="ui very compact table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Server</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                @endif
            </div> <!-- excluded segment -->
            <div class="ui attached header">
                <i class="clone icon"></i> Duplicate zones
            </div>
            <div class="ui orange bottom attached center aligned segment">
                @if ($duplicates === 0)
                    {{ __('No duplicate zones found.') }}
                @else
                    <div id="msg_dup">

                    </div>
                    <table id="table_duplicates" class="ui very compact table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Servers</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                @endif
            </div>
        </div> <!-- column -->
    </div>    <!-- grid -->
</div>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.semanticui.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.semanticui.min.js"></script>


<script type="text/javascript">
    $(document).ready(function () {
        var zones_table = $('#table_zones').DataTable({
            "pageLength": 100,
            columns:
            [
                {data: 'zone'},
                {data: 'server_name'},
                {data: 'insert_date'},
                {
                    data: 'server_name',
                    render: function(data, type, row, meta)
                    {
                        return '<button class="ui orange mini right labeled icon button btn_exclude" data-server_name="'+ data +'" data-zone="'+ row.zone +'" data-server="'+ row.server_id +'"><i class="exclamation mark icon"></i> EXCLUDE</button>';
                    }
                },

            ]
        });
        var excludes_table = $('#table_excludes').DataTable(
        {
            "pageLength": 10,
            columns:
            [
                {data: 'zone'},
                {data: 'server_name'},
                {
                    data: 'server_name',
                    render: function(data, type, row, meta)
                    {
                        return '<button class="ui red mini right labeled icon button btn_remove_exclude" data-server_name="'+ data +'" data-zone="'+ row.zone +'" data-server="'+ row.server_id +'"><i class="trash icon"></i> REMOVE EXCLUSION</button>';
                    }
                },

            ]

        });
        var duplicates_table = $('#table_duplicates').DataTable(
        {
            "pageLength": 10,
            columns:
            [
                {data: 'zone'},
                {
                    data: 'duplicate_servers',
                    render: function(data, type, row, meta)
                    {
                        var ret = "";
                        $.each(data, function(i, item)
                        {
			    ret += '<button class="ui orange mini right labeled icon button btn_exclude" data-server_name="'+ item.name +'" data-zone="'+ row.zone +'" data-server="'+ item.id +'"><i class="exclamation mark icon"></i>'+ item.name +'</button>';

                        });
                        return ret;
                    }
                },

            ]

        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax(
        {
            type: "GET",
            url: "/zones/all",
            success: function(response)
            {
                zones_table.clear();
                zones_table.rows.add(response).draw();
            }
        });
        $.ajax(
        {
            type: "GET",
            url: "/zones/excluded",
            success: function(response)
            {
                excludes_table.clear();
                excludes_table.rows.add(response).draw();
            }
        });

        $.ajax(
        {
            type: "GET",
            url: "/zones/duplicates",
            success: function(response)
            {
                duplicates_table.clear();
                duplicates_table.rows.add(response).draw();
            }
        });



        $(document).on('click', '.btn_exclude',  function () {
            var zone = $(this).data('zone');
            var server = $(this).data('server');
            var server_name = $(this).data('server_name')
            $('.modal_zone').text(zone);
            $('.modal_server').text(server_name);
            $('.ui.basic.modal.exclude')
                .modal({
                    onApprove : function() {
                        $.ajax({
                            type : 'POST',
                            url : '/zones/exclude',
                            data : {zone:zone, server:server},
                            success : function(response)
                                {
                                    if (response.code == "ok")
                                    {
                                        $('#msg').html('<div class="ui positive message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    else
                                    {
                                        $('#msg').html('<div class="ui negative message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    $('.message .close')
                                    .on('click', function() {
                                        $(this)
                                            .closest('.message')
                                            .transition('fade');
                                    });
                                }
                        })

                        return true;
                    }
                })
                .modal('show');
        });
        $(document).on('click', '.btn_remove_exclude', function ()
        {
            var zone = $(this).data('zone');
            var server = $(this).data('server');
            var server_name = $(this).data('server_name')
            $('.modal_remove_zone').text(zone);
            $('.modal_remove_server').text(server_name);
            $('.ui.basic.modal.remove_exclude')
                .modal({
                    onApprove : function() {
                        $.ajax({
                            type : 'POST',
                            url : '/zones/exclude/remove',
                            data : {zone:zone, server:server},
                            success : function(response)
                                {
                                    if (response.code == "ok")
                                    {
                                        $('#msg_remove').html('<div class="ui positive message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    else
                                    {
                                        $('#msg_remove').html('<div class="ui negative message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    $('.message .close')
                                    .on('click', function() {
                                        $(this)
                                            .closest('.message')
                                            .transition('fade');
                                    });
                                }
                        })

                        return true;
                    }
                })
                .modal('show');
        });
    });
</script>
@endsection
