@extends('layouts.app')

@section('content')
<div id="data_modal" class="ui modal">
    <i class="close icon"></i>
    <div class="header">
        Values
    </div>
    <div class="content">
        <div class="description">
            <div id="modal_data"></div>
        </div>
    </div>
</div>
<div class="ui stackable container">
    <div class="ui top attached header">
        <i class="clock icon"></i> {{ __('Logs') }}
    </div>
    <div class="ui teal attached segment">
        <div id="msg"></div>
        @if ($userlogs==null)
            {{ __('No logs found') }}
        @else
            <table id="table_logs" class="ui very compact table">
                <thead>
                    <tr>
                        <th>{{ __('User name') }}</th>
                        <th>{{ __('Action') }}</th>
                        <th>{{ __('IP') }}</th>
                        <th>{{ __('Time') }}</th>
                        <th>{{ __('Data') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($userlogs as $log)
                    <tr>
                        <td>{{ $log->username }} </td>
                        <td>{{ $log->action }}</td>
                        <td>{{ $log->ip }}</td>
                        <td data-order="{{ $log->timestamp }}">{{ \Carbon\Carbon::parse($log->timestamp)->format('j F Y H:i') }}</td>
                        <td> <button data-values="{{ $log->value }}" class="ui right labeled icon mini button data_btn"><i class="eye icon"></i>DATA</button>
                    </tr>
                @endforeach
                </tbody>
            </table>
        @endif
    </div>
</div>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.semanticui.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.semanticui.min.js"></script>

<script>
$(document).ready(function() {
    $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    $(document).on('click', '.data_btn', function() {
        var data = $(this).data('values');
        var output = '<table class="ui very compact celled table">';
        Object.keys(data).forEach(function(key) {
            output = output + '<tr><td>' + key + '</td><td>' + data[key] + '</td></tr>';
        });
        output = output + '</table>';
        

        $('#modal_data').html(output);
        $('#data_modal').modal('show');
    });
    $('#table_logs').DataTable(
        {
            "pageLength": 50,
            "order": [[3, "desc"]]
        }
    );
} );
</script>
@endsection
