@extends('layouts.app')

@section('content')

<div class="ui stackable container">
    <div class="ui top attached header">
        {{ __('Server incidents') }}
    </div>
    <div class="ui attached segment">
    @foreach($incidents as $server)
        <div class="ui top attached header">
            {{ $server->server_name }}
        </div>
        <div class="ui attached segment">
        @if(count($server->data)>0)
            <table class="ui very compact table">
                <thead>
                    <tr>
                        <th>{{ __('Duration') }}</th>
                        <th>{{ __('Start timestamp') }}</th>
                        <th>{{ __('End timestamp') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($server->data as $incident)
                        <tr>
                            <td class="negative">{{ $incident[0]['duration'] }}</td>
                            <td>{{ $incident[0]['start'] }}</td>
                            <td>{{ $incident[0]['stop'] }}</td>
                        </tr> 
                    @endforeach
                </tbody>
            </table>
        @else
            {{ __('No incidents found') }}
        @endif
        </div>
    @endforeach
    </div>
</div>

@endsection
