@extends('layouts.app')

@section('content')
<div id="dig_modal" class="ui modal">
    <i class="close icon"></i>
    <div class="header">
        <span id="dig_zone"></span>
    </div>
    <div class="content">
        <div class="description">
            <div class="ui fluid buttons">
                <button class="ui button" id="a_dig">A records</button>
                <button class="ui button" id="mx_dig">MX records</button>
                <button class="ui button" id="ns_dig">NS records</button>
            </div>
            <pre>
                <div id="dig_result" style="background-color:black;color:white;padding:20px;border-radius:5px;"></div>
            </pre>
        </div>
    </div>
</div>
<div class="ui stackable container">
    <div class="ui top attached header">
        <i class="clock icon"></i> {{ __('Logs') }}
    </div>
    <div class="ui teal attached segment">
        <div id="msg"></div>
            <div class="row" style="padding-bottom:20px">
              <div class="field">
                  <div class="ui fluid labeled action input">
                      <input id="query" type="text" name="query" placeholder="Search query" required>
                      <button id="btnSearch" class="ui button" type="button">Search</button>
                  </div>
              </div>
            </div>
            <table id="table_logs" class="ui very compact table">
                <thead>
                    <tr>
                        <th>{{ __('Zone') }}</th>
                        <th>{{ __('Action') }}</th>
                        <th>{{ __('Server') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                </thead>
                <tbody>
                  <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                  </tr>
                </tbody>
            </table>
    </div>
</div>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.semanticui.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.semanticui.min.js"></script>

<script>
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    var table = $('#table_logs').DataTable(
        {
            "pageLength": 50,
            "order": [[3, "desc"]],
            language:
            {
              search: "Quick filter:",
            },
            columns:
            [
              {
                data: 'zone',
                render: function(data, type, row, meta)
                {
                  return data + '<button data-zone="'+ data +'" class="ui right floated right labeled icon mini button dig_btn"><i class="terminal icon"></i>dig check</button>';
                }
              },
              {data: 'action'},
              {data: 'server_name'},
              {data: 'timestamp'},
            ],
        }
    );

    function search(query)
    {
      $.ajax(
      {
        type: "POST",
        url: "/logs/query",
        data: {query:query},
        success: function(response)
        {
          table.clear();
          table.rows.add(response).draw();
        }
      });
    }
    search("");
    $(document).on('click', '#btnSearch', function()
    {
      search($('#query').val());
    });
    $('#dig_modal').on('click', '#a_dig', function()
    {
        var zone = $('#dig_zone').text();
        var type = 'A';
        getZoneInfo(zone, type);
    });

    $('#dig_modal').on('click', '#mx_dig', function()
    {
        var zone = $('#dig_zone').text();
        var type = 'MX';
        getZoneInfo(zone, type);
    });

    $('#dig_modal').on('click', '#ns_dig', function()
    {
        var zone = $('#dig_zone').text();
        var type = 'NS';
        getZoneInfo(zone, type);
    });


    $('#table_logs').on('click', '.dig_btn', function() {
        var zone = $(this).data('zone');
        $('#dig_zone').html(zone);
        $('#dig_modal')
            .modal('show');
        $('#dig_result').hide();

    });
} );
function getZoneInfo(zone, type)
{
    $.ajax({
        type : 'POST',
        url : '/digcheck',
        data : {zone:zone, type:type},
        beforeSend : function ()
        {
            $('#dig_result').show();
            $('#dig_result').html('<div class="ui active centered inline loader"></div>');
        },
        success : function(response)
        {
            var output = '<table>';
            for (var i = 0; i < response.message.length; i++)
            {
                output = output + '<tr><td>' + Object.keys(response.message[i])[0] + ':</td><td>';
                //output = output +  Object.keys(response.message[i])[0] + " : ";
                for (var key in response.message[i])
                {
                    output = output + ' ' + response.message[i][key];
                    //output = output + response.message[i][key];
                }
                output = output + '</td></tr>';
            }
            output = output + '</table>';
            if (response.code == "ok")
            {
                $('#dig_result').html(output);
            }
            else
            {
                $('#dig_result').html('Command failed.');
            }
        }
    });

}
</script>
@endsection
