@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    <div class="ui top attached header">{{ __('Login') }}</div>

    <div class="ui teal attached segment">
        <form method="POST" action="{{ route('login') }}" class="ui form">
            @csrf

            <div class="field">
                <div class="ui labeled input">
                    <label class="ui label">{{ __('E-Mail Address') }}</label>

                    <input id="email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
            </div>

            <div class="field">
                <div class="ui labeled input">
                    <label class="ui label">{{ __('Password') }}</label>
                    <input id="password" type="password" name="password" required autocomplete="current-password">

                    @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
            </div>

            <div class="field">
                <div class="ui slider checkbox">
                    <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>

                    <label for="remember">
                        {{ __('Remember Me') }}
                    </label>
                </div>
            </div>

            <div class="field">
                <button type="submit" class="ui primary button">
                    {{ __('Login') }}
                </button>
            </div>
            <div>
                @if (Route::has('password.request'))
                    <a class="ui button" href="{{ route('password.request') }}">
                        {{ __('Forgot Your Password?') }}
                    </a>
                @endif
            </div>
        </form>
    </div>
</div>
@endsection
