@extends('layouts.app')

@section('content')
<div id="user_modal" class="ui modal">
    <i class="close icon"></i>
    <div class="header">
        <span id="user_name"></span>
    </div>
    <div class="content">
        <div id="user_msg"></div>
        <div class="ui form">
            <div class="field">
                <div class="ui input">
                    <input type="text" id="user_name_input" placeholder="User name">
                </div>
            </div>
             <div class="field">
                <div class="ui input">
                    <input type="email" id="user_email_input" placeholder="User e-mail">
                </div>
            </div>
            <div class="field">
                <div class="ui input">
                    <input type="text" id="user_password_input" placeholder="User password (leave empty to not change)">
                    <input type="hidden" id="user_id">
                </div>
            </div>
        </div>
    </div>
    <div class="actions">
        <button id="btn_save" class="ui teal right labeled icon button">
            Save
            <i class="save icon"></i>
        </button>
    </div>
</div> <!-- edit user modal -->
<div id="add_user_modal" class="ui modal">
    <i class="close icon"></i>
    <div class="header">
        <i class="plus icon"></i> {{ __('Add user') }}
    </div>
    <div class="content">
        <div id="add_user_msg"></div>
        <div class="ui form">
            <div class="field">
                <div class="ui input">
                    <input type="text" id="add_user_name_input" placeholder="User name">
                </div>
            </div>
             <div class="field">
                <div class="ui input">
                    <input type="email" id="add_user_email_input" placeholder="User e-mail">
                </div>
            </div>
            <div class="field">
                <div class="ui input">
                    <input type="text" id="add_user_password_input" placeholder="User password">
                </div>
            </div>
        </div>
    </div>
    <div class="actions">
        <button id="btn_add_user" class="ui teal right labeled icon button">
            Create
            <i class="plus icon"></i>
        </button>
    </div>
</div> <!-- Create user modal -->
<div id="delete_user_modal" class="ui modal">
    <i class="close icon"></i>
    <div class="header">
        <i class="trash icon"></i> {{ __('Remove user') }}
    </div>
    <div class="content">
        <div id="delete_user_msg"></div>
        <input type="hidden" id="delete_user_id">
        <div class="ui warning message">You are about to delete <strong><span id="delete_user_name"></span></strong>. Continue?</div>
    </div>
    <div class="actions">
        <button id="btn_delete_user" class="ui red right labeled icon button">
            Delete
            <i class="trash icon"></i>
        </button>
    </div>
</div> <!-- Delete user modal -->


<div class="ui stackable container">
    <div class="ui top attached header">
        <i class="user icon"></i> Users
    </div>
    <div class="ui teal center aligned bottom attached segment">
        <button id="create_user_btn" class="ui teal right labeled icon button"><i class="plus icon"></i> CREATE USER</button>
    @if (count($users) == 0)
        <div class="ui negative message">{{ __('No users found.') }}</div>
    @else
        <table class="ui very compact celled table">
            <thead>
                <tr>
                    <th>{{ __('Name') }}</th>
                    <th>{{ __('E-mail') }}</th>
                    <th><i class="cog icon"></i></th>
                </tr>
            </thead>
            <tbody>
            @foreach ($users as $user)
                <tr>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td><button class="ui mini right labeled icon button btn_edit" data-email="{{ $user->email }}" data-name="{{ $user->name }}" data-user_id="{{ $user->id }}"><i class="edit icon"></i> EDIT</button> <button class="ui red mini right labeled icon button btn_delete" data-name="{{ $user->name }}" data-user_id="{{ $user->id }}">DELETE <i class="trash icon"></i></td>
                </tr>
            @endforeach
            </tbody>
        </table>
    @endif
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function ()
    {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $(document).on('click', '#create_user_btn', function ()
        {
            $('#add_user_msg').html('');
            $('#add_user_name_input').val('');
            $('#add_user_email_input').val('');
            $('#add_user_password_input').val('');
            $('#add_user_modal').modal('show');
        });

        $(document).on('click', '.btn_delete', function ()
        {
            var name = $(this).data('name');
            var id = $(this).data('user_id');

            $('#delete_user_id').val(id);
            $('#delete_user_name').html(name);
            $('#delete_user_msg').html('');
            $('#delete_user_modal').modal('show');
        });

        $(document).on('click', '#btn_delete_user', function ()
        {
            var id = $('#delete_user_id').val();
            $.ajax({
                type : 'POST',
                url : '/users/delete',
                data : {id:id},
                success : function(response) 
                {
                    
                    if (response.code == "ok")
                    {
                        $('#delete_user_msg').html('<div class="ui positive message">' + response.message + '</div>');
                    }
                    else
                    {
                         $('#delete_user_msg').html('<div class="ui negative message">' + response.message + '</div>');
                    }
                }
            });
        });
        $('#btn_add_user').on('click', function () {
            var name = $('#add_user_name_input').val();
            var email = $('#add_user_email_input').val();
            var password = $('#add_user_password_input').val();
            if ( name == "" || email == ""  || password == "" )
            {
                alert('Fill in the fields');
                return;
            }
            $.ajax({
                type : 'POST',
                url : '/users/create',
                data : {name:name, email:email, password:password},
                success : function(response) 
                {
                    
                    if (response.code == "ok")
                    {
                        $('#add_user_msg').html('<div class="ui positive message">' + response.message + '</div><div class="ui divider"></div>');
                    }
                    else
                    {
                         $('#add_user_msg').html('<div class="ui negative message">' + response.message + '</div><div class="ui divider"></div>');
                    }
                },
                error : function(xhr, status, err)
                {
                    var errors = $.parseJSON(xhr.responseText);
                    var msg = "";
                    $.each(errors, function (key, value)
                    {
                        if (key=="errors")
                        {
                            var error = value;
                            $.each(error, function (ekey, evalue)
                            {
                                msg += ekey + ": ";
                                $.each(evalue, function (error_key, error_msg)
                                {
                                    msg += error_msg + " ";
                                });
                            });
                        }
                    });
                    $('#add_user_msg').html('<div class="ui negative message">' + msg + '</div><div class="ui divider"></div>');
                }
            });
        });

        $(document).on('click', '.btn_edit', function ()
        {
            var name = $(this).data('name');
            var id = $(this).data('user_id');
            var email = $(this).data('email');
            $('#user_name').html(name);
            $('#user_name_input').val(name);
            $('#user_email_input').val(email);
            $('#user_id').val(id);
            $('#user_password_input').val('');
            $('#user_msg').html('');
            $('#user_modal').modal('show');
        });
        $('#btn_save').on('click', function () {
            var new_name = $('#user_name_input').val();
            var new_email = $('#user_email_input').val();
            var new_password = $('#user_password_input').val();
            var id = $('#user_id').val();
            if ( new_name == "" || new_email == "" )
            {
                alert('Fill in the fields');
                return;
            }
            $.ajax({
                type : 'POST',
                url : '/users/save',
                data : {id:id, name:new_name, email:new_email, password:new_password},
                success : function(response) 
                {
                    
                    if (response.code == "ok")
                    {
                        $('#user_msg').html('<div class="ui positive message">' + response.message + '</div><div class="ui divider"></div>');
                    }
                    else
                    {
                         $('#user_msg').html('<div class="ui negative message">' + response.message + '</div><div class="ui divider"></div>');
                    }
                },
                error : function(xhr, status, err)
                {
                    var errors = $.parseJSON(xhr.responseText);
                    var msg = "";
                    $.each(errors, function (key, value)
                    {
                        if (key=="errors")
                        {
                            var error = value;
                            $.each(error, function (ekey, evalue)
                            {
                                msg += ekey + ": ";
                                $.each(evalue, function (error_key, error_msg)
                                {
                                    msg += error_msg + " ";
                                });
                            });
                        }
                    });
                    $('#user_msg').html('<div class="ui negative message">' + msg + '</div><div class="ui divider"></div>');
                }
            });
        });
    });
</script>
@endsection
