@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    <div class="ui top attached header">
        <i class="sitemap icon"></i> Clusters
    </div>
    <div class="ui teal attached center aligned segment">
        <a class="ui teal right labeled icon button" href="{{ route('add-cluster-form') }}"><i class="plus icon"></i> CREATE CLUSTER</a>
        <div class="ui divider"></div>
        @if (count($clusters) === 0)
            {{ __('No clusters found.') }}
        @else
            <table class="ui very compact table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Notifications</th>
                        <th>Servers (Alive / Total)</th>
                        <th>Zones (Total / Excluded)</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clusters as $cluster)
                        <tr>
                            <td>{{ $cluster->name }}</td>
                            <td>
                                @if( $cluster->email_notifications )
                                    {{ __('On') }}
                                @else
                                    {{ __('Off') }}
                                @endif
                            </td>
                            <td>
                                <span style="color: #0B0;">{{ $cluster->getAvailableServers() }}</span> / {{ $cluster->getTotalServers() }}
                            </td>
                            <td>
                                {{ $cluster->getTotalZones() }} / {{ $cluster->getExcludedZones() }}
                            </td>
                            <td>
                                <a class="ui mini right labeled icon button" href="{{ route('edit-cluster-form', ['id' => $cluster->id]) }}"><i class="edit icon"></i> EDIT</a>
                                <a class="ui red mini right labeled icon button" href="{{ route('delete-cluster-form', ['id' => $cluster->id] ) }}"><i class="trash icon"></i> DELETE</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
</div>
@endsection
