@extends('layouts.app')

@section('content')

<div class="ui stackable container">
    <div class="ui top attached header">
       {{ __('Reset Password') }} 
    </div> 
    <div class="ui teal attached center aligned segment">
        @if (session('status'))
            <div class="ui positive message" role="alert">
                {{ session('status') }}
            </div>
        @endif

        <form class="ui stackable form" method="POST" action="{{ route('password.email') }}">
            @csrf
            <div class="field @error('email') error @enderror">
                <div class="ui input">
                    <input id="email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="E-mail">
                </div>
            </div>
            <div class="ui action">
                <input type="submit" class="ui primary button" value="{{ __('Send Password reset link') }}">
            </div>
        </form>
    </div>
</div>
@endsection
