@extends('layouts.app')

@section('content')
<div class="ui stackable fluid container">
    <div class="ui stackable grid">
        <div class="eleven wide column">
            <div class="ui top attached header">
                <i class="home icon"></i> Home</i>
            </div>
            <div class="ui teal attached center aligned segment">
                <div class="ui buttons">
                    <a href="{{ route('add-server') }}" class="ui teal labeled icon button"><i class="server icon"></i> ADD A SERVER</A>
                    <div class="or"></div>
                    <a href="{{ route('add-cluster-form') }}" class="ui teal right labeled icon button"><i class="sitemap icon"></i> ADD A CLUSTER</A>
                </div>
                <div class="ui divider"></div>
                @if (count($servers_agents)+count($servers_nodes) === 0)
                    {{ __('No servers found') }}
                @else
                    @if (count($servers_agents) > 0)
                    <div class="ui centered header">
                        Agents
                    </div>
                    <table class="ui very compact selectable celled table">
                        <thead>
                            <tr>
                                <th>Server name</th>
                                <th>Last seen</th>
                                <th>Zones</th>
                                <th>Cluster</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($servers_agents as $server)
                                <tr>
                                    <td>{{ $server->name }} @if ($server->version) <span class="ui tiny teal label">ver: {{ $server->version }}</span> @endif</td>
                                    <td class="@if ($server->getBoolLastSeen()) {{ _('positive') }} @else {{ __('negative') }} @endif">{{ $server->getDiffForHumans() }} {{ __('ago') }}</td>
                                    <td>{{ $server->zones_count }}</td>
                                    <td>{{ $server->getCluster() }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @endif
                    @if (count($servers_nodes) > 0)
                    <div class="ui centered header">
                        Nodes
                    </div>
                    <table class="ui very compact selectable celled table">
                        <thead>
                            <tr>
                                <th>Server name</th>
                                <th>Last seen</th>
                                <th>Zones</th>
                                <th>Cluster</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($servers_nodes as $server)
                                <tr>
                                    <td>{{ $server->name }} @if ($server->version) <span class="ui tiny teal label">ver: {{ $server->version }}</span> @endif</td>
                                    <td class="@if ($server->getBoolLastSeen()) {{ _('positive') }} @else {{ __('negative') }} @endif">{{ $server->getDiffForHumans() }} {{ __('ago') }}</td>
                                    <td>{{ $server->zones_count }}</td>
                                    <td>{{ $server->getCluster() }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @endif
                @endif
            </div>
        </div><!-- main column -->
        <div class="five wide column">
            <div class="ui top attached header">
                <i class="clock icon"></i> {{ __('Latest logs') }}
            </div>
            <div class="ui grey attached segment">
                @if (count($logs) === 0)
                    {{ __('No logs found') }}
                @else
                    <table class="ui very compact table">
                        @foreach ($logs as $log)
                            <tr data-tooltip="{{ $log->timestamp }} @ {{ $log->server_name }}">
                                <td>{{ $log->action }}</td>
                                <td>{{ $log->zone }}</td>
                            </tr>
                        @endforeach
                    </table>
                @endif
            </div>
            @if ( count($faulty_clusters) > 0 )
                <div class="ui attached header">
                    {{ _('Problems') }}
                </div>
                <div class="ui orange attached segment">
                    {{ _('Clusters with problems:') }}
                    <ul>
                        @foreach ($faulty_clusters as $cluster)
                            <li>{{ $cluster->name }}</li>
                       @endforeach 
                    </ul
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
