@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    @if ($server->isEmpty())
        {{ __('Server not found') }}
    @else
    <div class="ui top attached header">
            <i class="edit icon"></i> {{ $server[0]->name }}
        </div>
        <div class="ui teal attached segment">
            <form class="ui stackable form" method="POST" action="">
                <div class="field">
                    <div class="ui input">
                        <input type="text" name="name" placeholder="Server name" value="{{ $server[0]->name }}" required autofocus>
                    </div>
                </div>
                <div class="field">
                    <div class="ui labeled action input">
                        <input id="token" type="text" name="token" placeholder="Server token" value="{{ $server[0]->token }}" required>
                        <button type="button" id="tokenGenerator" class="ui button">GENERATE</button>
                    </div>
                </div>
                <div class="field">
                    <div class="ui input">
                        <input type="text" name="IP" placeholder="IP" value="{{ $server[0]->IP }}" required>
                    </div>
                </div>
                <div class="two fields">
                    <div class="field">
                        <select name="type">
                            <option value=1 @if ($server[0]->type === 1) {{ __('selected')}} @endif>{{ __('Agent') }}</option>
                            <option value=2 @if ($server[0]->type === 2) {{ __('selected')}} @endif>{{ __('Node') }}</option>
                        </select>
                    </div>
                    <div class="field">
                        <select name="cluster_id">
                            @foreach ($clusters as $cluster)
                                <option value="{{ $cluster->id }}" @if ( $server[0]->cluster_id == $cluster->id ) {{__('selected') }} @endif >{{ $cluster->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="ui action">
                    @csrf
                    <input type="submit" class="ui primary button" value="Save">
                </div>
            </form>
        </div>
        
    @endif
</div>

<script type="text/javascript">
$( document ).ready(function() {

// set the length of the string
var stringLength = 32;

// list containing characters for the random string
var stringArray = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];

$("#tokenGenerator").click(function (){

    var rndString = "";

    // build a string with random characters
    for (var i = 1; i < stringLength; i++) { 
        var rndNum = Math.ceil(Math.random() * stringArray.length) - 1;
        rndString = rndString + stringArray[rndNum];
    };
    
    $("#token").val(rndString);

});

});
</script>
@endsection
 
