@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    <div class="ui top attached header">
       {{ __('Reset Password') }} 
    </div> 
    <div class="ui teal attached center aligned segment">
        <form class="ui stackable form" method="POST" action="{{ route('password.update') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $token }}">
            <div class="field @error('email') error @enderror">
                <div class="ui input">
                    <input placeholder="E-mail" id="email" type="email" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>
                </div>
            </div>
            <div class="field @error('password') error @enderror">
                <div class="ui input">
                    <input placeholder="New password" id="password" type="password" name="password" required autocomplete="new-password">
                </div>
            </div>
            <div class="field">
                <div class="ui input">
                    <input placeholder="Confirm new password" id="password-confirm" type="password" name="password_confirmation" required autocomplete="new-password">
                </div>
            </div>
            <div class="ui action">
                <input type="submit" class="ui primary button" value="{{ __('Reset Password') }}">
            </div>
        </form>
    </div>
</div>
@endsection
