@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    <form class="ui stackable form" method="POST" action="">
        <div class="ui top attached header">
            <i class="cog icon"></i> Settings
        </div>
			<div class="ui teal attached segment">
			@if ($errors->any())
				<div class="ui negative message">
					<ul>
					@foreach ($errors->all() as $error)
						<li>{{ $error }}</li>
					@endforeach
					</ul>
				</div>
			@endif
            @if (Request()->message)
                <div class="ui message">
                    {{ Request()->message }}
                </div>
            @endif
                <div class="two fields">
                    <div class="field">
                        <div class="ui labeled input">
                            <div class="ui label">
                                Last seen threshold in minutes:
                            </div>
                            <input type="number" name="last_seen" value="{{ $last_seen->getValue() }}" placeholder="Last seen limit" required autofocus>
                        </div>
                    </div>
                    <div class="field">
                        <div class="ui slider checkbox">
                            <input type="checkbox" id="email_notifications" name="email_notifications" @if ($email_notifications->getValue()) {{ __('checked') }} @endif>
                            <label for="email_notifications"><i class="envelope icon"></i> Email notifications <i class="question mark icon" data-content="Notifications for latest logs & problems"></i> </label>
                        </div>
                    </div>
                </div>
                <div class="two fields">
                    <div class="field">
                        <div class="ui labeled input">
                            <div class="ui label">
                                Notifications recipient:
                            </div>
                            <input type="text" name="notifications_recipient" placeholder="e.g. alerts@mydomain.com" value="{{ $notifications_recipient->getValue() }}">
                        </div>
                    </div>
                </div>
            </div>
            <div class="ui attached centered header">
                Updates <span class="ui label" id="current_version"></span>
            </div>
            <div class="ui attached segment">
                <div class="ui stackable grid">
                    <div class="row">
                        <div class="sixteen wide column">
                            <button class="ui labeled icon basic button" id="update_btn" type="button">
                                <i class="sync icon"></i>
                                {{ __('Check for updates') }}
                            </button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="sixteen wide column">
                            <div id="update_msg"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ui attached centered header">
                <i class="info circle icon"></i> License Status
            </div>
            <div class="ui attached segment">
                @if ($license_data === false)
                    {{ __('Can\'t get license data') }} 
                @else
                <table class="ui very tiny table">
                    <tbody>
                        <tr>
                            <td>Status</td>
                            <td>{{ $license_data->status }}</td>
                        </tr>
                        <tr>
                            <td>Registered to</td>
                            <td>{{ $license_data->registeredname }}</td>
                        </tr>
                         <tr>
                            <td>Expiry date</td>
                            <td>{{ $license_data->nextduedate }}</td>
                        </tr>
                    </tbody>
                </table> 
                @endif
            </div>
            <div class="ui right aligned attached segment">
                <div class="ui action">
                    @csrf
                    <button type="submit" class="ui teal right labeled icon button"><i class="save icon"></i> {{ __('Save') }}</button>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
    $('.icon').popup();
    $(document).ready(function ()
    {
        $.ajax({
            type: 'GET',
            url: '/updater.currentVersion',
            success: function(response)
            {
                $('#current_version').html('current version: ' + response);
            }
        });
        $(document).on('click', '#update_btn', function()
        {
            $.ajax({
                type: 'GET',
                url: '/updater.check',
                async: false,
                success: function(response)
                {
                    if(response != '')
                    {
                        $('#update_msg').html('<div class="ui info message"><div class="header">Update available! <div class="ui label">' + response + '</div></div><a href="/updater.update" class="ui basic tiny button">Click here</a> to start upgrade.</div>');
                    }
                    else
                    {
                        $('#update_msg').html('<div class="ui positive message">Controller is already on latest version.</div>');

                    }
                }
        })
    });
    });
</script>
@endsection

 
