@extends('layouts.app')

@section('content')
<div class="ui stackable fluid container">
    <div class="ui top attached header">
        <i class="server icon"></i> Servers</i>
    </div>
    <div class="ui teal attached center aligned segment">
        <a href="{{ route('add-server') }}" class="ui teal right labeled icon button"><i class="plus icon"></i> CREATE SERVER</a>
    </div>
    @if(count($clusters) > 0)
    <div class="ui attached center aligned segment">
        <div id="msg_cluster"></div>
        <button class="ui button" id="btn_cluster_recheck">{{ __('Force recheck cluster:') }}</button>
        <select id="cluster_recheck" class="ui dropdown">
            <option value="all">{{ __('All') }}</option>
            @foreach($clusters as $cluster)
            <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
            @endforeach
        </select> 
    </div>
    @endif
    <div class="ui attached center aligned segment">
        @if (count($servers) === 0)
            No servers found
        @else
            <div id="msg"></div>
            <table class="ui very compact table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Token</th>
                        <th>Type</th>
                        <th>IP</th>
                        <th>Zones</th>
                        <th>Cluster</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($servers as $server)
                        <tr>
                            <td>{{ $server->name }}</td>
                            <td>{{ $server->token }}</td>
                            <td>{{ $server->getType() }}</td>
                            <td>{{ $server->IP }}</td>
                            <td>{{ $server->zones_count }}</td>
                            <td>{{ $server->getCluster() }}</td>
                            <td>
                                <a href="{{ route('edit-server-form', ['id' => $server->id]) }}" class="ui mini right labeled icon button"><i class="edit icon"></i> EDIT</a>
                                <a href="{{ route('delete-server', ['id' => $server->id]) }}" class="ui red mini right labeled icon button"><i class="trash icon"></i> DELETE</a>
                                <button class="ui mini right labeled icon button btn_recheck" data-server_id="{{ $server->id }}"><i class="refresh icon"></i> FORCE RE-CHECK</button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $('.ui.dropdown').dropdown();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $("#btn_cluster_recheck").on("click", function (){
            var cluster = $("#cluster_recheck").val();
            $.ajax({
                type : 'POST',
                url : '/servers/recheck_cluster',
                data : {cluster:cluster},
                success : function(response) 
                {
                    if (response.code == "ok")
                    {
                        $('#msg_cluster').html('<div class="ui positive message"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    else
                    {
                        $('#msg_cluster').html('<div class="ui negative message"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    $('.message .close')
                    .on('click', function() {
                        $(this)
                            .closest('.message')
                            .transition('fade');
                    });
                }
            })
        });
        $(".btn_recheck").on("click", function(){
            var server_id = $(this).data("server_id");
            $.ajax({
                type : 'POST',
                url : '/servers/recheck',
                data : {server_id:server_id},
                success : function(response) 
                {
                    if (response.code == "ok")
                    {
                        $('#msg').html('<div class="ui positive message"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    else
                    {
                        $('#msg').html('<div class="ui negative message"><i class="close icon"></i>\
                        ' + response.message + '\
                        </div>');
                    }
                    $('.message .close')
                    .on('click', function() {
                        $(this)
                            .closest('.message')
                            .transition('fade');
                    });
                }
            })

        })
        
        });
</script>
@endsection
